/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.MGF1BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.MGFParameters;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASha2NativeEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

class SLHDSASha2Engine
extends SLHDSAEngine {
    private final HMac treeHMac;
    private final MGF1BytesGenerator mgf1;
    private final byte[] hmacBuf;
    private final Digest msgDigest;
    private final byte[] msgDigestBuf;
    private final int bl;
    private final Digest sha256 = SHA256Digest.newInstance();
    private final byte[] sha256Buf = new byte[this.sha256.getDigestSize()];
    private Memoable msgMemo;
    private Memoable sha256Memo;

    public static SLHDSAEngine newInstance(int n, int n2, int n3, int n4, int n5, int n6) {
        if (CryptoServicesRegistrar.hasEnabledService("SLHDSA_SHA256") && n == 16) {
            return new SLHDSASha2NativeEngine(n, n2, n3, n4, n5, n6);
        }
        return new SLHDSASha2Engine(n, n2, n3, n4, n5, n6);
    }

    private SLHDSASha2Engine(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        if (n == 16) {
            this.msgDigest = SHA256Digest.newInstance();
            this.treeHMac = new HMac(SHA256Digest.newInstance());
            this.mgf1 = new MGF1BytesGenerator(SHA256Digest.newInstance());
            this.bl = 64;
        } else {
            this.msgDigest = SHA512Digest.newInstance();
            this.treeHMac = new HMac(SHA512Digest.newInstance());
            this.mgf1 = new MGF1BytesGenerator(SHA512Digest.newInstance());
            this.bl = 128;
        }
        this.hmacBuf = new byte[this.treeHMac.getMacSize()];
        this.msgDigestBuf = new byte[this.msgDigest.getDigestSize()];
    }

    @Override
    void init(byte[] byArray) {
        byte[] byArray2 = new byte[this.bl];
        this.msgDigest.update(byArray, 0, byArray.length);
        this.msgDigest.update(byArray2, 0, this.bl - this.N);
        this.msgMemo = ((Memoable)((Object)this.msgDigest)).copy();
        this.msgDigest.reset();
        this.sha256.update(byArray, 0, byArray.length);
        this.sha256.update(byArray2, 0, 64 - byArray.length);
        this.sha256Memo = ((Memoable)((Object)this.sha256)).copy();
        this.sha256.reset();
    }

    @Override
    public byte[] F(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = this.compressedADRS(aDRS);
        ((Memoable)((Object)this.sha256)).reset(this.sha256Memo);
        this.sha256.update(byArray3, 0, byArray3.length);
        this.sha256.update(byArray2, 0, byArray2.length);
        this.sha256.doFinal(this.sha256Buf, 0);
        return Arrays.copyOfRange(this.sha256Buf, 0, this.N);
    }

    @Override
    public byte[] H(byte[] byArray, ADRS aDRS, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = this.compressedADRS(aDRS);
        ((Memoable)((Object)this.msgDigest)).reset(this.msgMemo);
        this.msgDigest.update(byArray4, 0, byArray4.length);
        this.msgDigest.update(byArray2, 0, byArray2.length);
        this.msgDigest.update(byArray3, 0, byArray3.length);
        this.msgDigest.doFinal(this.msgDigestBuf, 0);
        return Arrays.copyOfRange(this.msgDigestBuf, 0, this.N);
    }

    @Override
    IndexedDigest H_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        int n = (this.A * this.K + 7) / 8;
        int n2 = this.H / this.D;
        int n3 = this.H - n2;
        int n4 = (n2 + 7) / 8;
        int n5 = (n3 + 7) / 8;
        int n6 = n + n4 + n5;
        byte[] byArray6 = new byte[n6];
        byte[] byArray7 = new byte[this.msgDigest.getDigestSize()];
        this.msgDigest.update(byArray, 0, byArray.length);
        this.msgDigest.update(byArray2, 0, byArray2.length);
        this.msgDigest.update(byArray3, 0, byArray3.length);
        if (byArray4 != null) {
            this.msgDigest.update(byArray4, 0, byArray4.length);
        }
        this.msgDigest.update(byArray5, 0, byArray5.length);
        this.msgDigest.doFinal(byArray7, 0);
        byArray6 = this.bitmask(Arrays.concatenate(byArray, byArray2, byArray7), byArray6);
        byte[] byArray8 = new byte[8];
        System.arraycopy(byArray6, n, byArray8, 8 - n5, n5);
        long l = Pack.bigEndianToLong(byArray8, 0);
        byte[] byArray9 = new byte[4];
        System.arraycopy(byArray6, n + n5, byArray9, 4 - n4, n4);
        int n7 = Pack.bigEndianToInt(byArray9, 0);
        return new IndexedDigest(l &= -1L >>> 64 - n3, n7 &= -1 >>> 32 - n2, Arrays.copyOfRange(byArray6, 0, n));
    }

    @Override
    public byte[] T_l(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = this.compressedADRS(aDRS);
        ((Memoable)((Object)this.msgDigest)).reset(this.msgMemo);
        this.msgDigest.update(byArray3, 0, byArray3.length);
        this.msgDigest.update(byArray2, 0, byArray2.length);
        this.msgDigest.doFinal(this.msgDigestBuf, 0);
        return Arrays.copyOfRange(this.msgDigestBuf, 0, this.N);
    }

    @Override
    byte[] PRF(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        int n = byArray2.length;
        ((Memoable)((Object)this.sha256)).reset(this.sha256Memo);
        byte[] byArray3 = this.compressedADRS(aDRS);
        this.sha256.update(byArray3, 0, byArray3.length);
        this.sha256.update(byArray2, 0, byArray2.length);
        this.sha256.doFinal(this.sha256Buf, 0);
        return Arrays.copyOfRange(this.sha256Buf, 0, n);
    }

    @Override
    public byte[] PRF_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.treeHMac.init(new KeyParameter(byArray));
        this.treeHMac.update(byArray2, 0, byArray2.length);
        if (byArray3 != null) {
            this.treeHMac.update(byArray3, 0, byArray3.length);
        }
        this.treeHMac.update(byArray4, 0, byArray4.length);
        this.treeHMac.doFinal(this.hmacBuf, 0);
        return Arrays.copyOfRange(this.hmacBuf, 0, this.N);
    }

    private byte[] compressedADRS(ADRS aDRS) {
        byte[] byArray = new byte[22];
        System.arraycopy(aDRS.value, 3, byArray, 0, 1);
        System.arraycopy(aDRS.value, 8, byArray, 1, 8);
        System.arraycopy(aDRS.value, 19, byArray, 9, 1);
        System.arraycopy(aDRS.value, 20, byArray, 10, 12);
        return byArray;
    }

    protected byte[] bitmask(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length];
        this.mgf1.init(new MGFParameters(byArray));
        this.mgf1.generateBytes(byArray3, 0, byArray3.length);
        Bytes.xorTo(byArray2.length, byArray2, byArray3);
        return byArray3;
    }

    protected byte[] bitmask(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        this.mgf1.init(new MGFParameters(byArray));
        this.mgf1.generateBytes(byArray4, 0, byArray4.length);
        Bytes.xorTo(byArray2.length, byArray2, byArray4);
        Bytes.xorTo(byArray3.length, byArray3, 0, byArray4, byArray2.length);
        return byArray4;
    }

    protected byte[] bitmask256(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length];
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(new SHA256Digest());
        mGF1BytesGenerator.init(new MGFParameters(byArray));
        mGF1BytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        Bytes.xorTo(byArray2.length, byArray2, byArray3);
        return byArray3;
    }
}

