/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dragdrop.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DragAndDropResource {
    private final UserAccessor userAccessor;
    private static final String DRAG_AND_DROP_TIP_SETTING_KEY = "show-drag-and-drop-tip";

    @Inject
    public DragAndDropResource(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @POST
    @Path(value="tip/disable")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response disableShowTip() {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(AuthenticatedUserThreadLocal.get());
        try {
            userPreferences.setString(DRAG_AND_DROP_TIP_SETTING_KEY, "false");
        }
        catch (UserPreferences.PreferenceException e) {
            return Response.serverError().build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="tip/setting")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getTipSetting() {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(AuthenticatedUserThreadLocal.get());
        String value = userPreferences.getString(DRAG_AND_DROP_TIP_SETTING_KEY).isPresent() ? (String)userPreferences.getString(DRAG_AND_DROP_TIP_SETTING_KEY).get() : "";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
    }
}

