/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.aggregation.impl;

import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.event.events.admin.AbstractRestoreEvent;
import com.atlassian.confluence.event.events.admin.RestoreLockDatabaseEvent;
import com.atlassian.confluence.event.events.admin.RestoreUnlockDatabaseEvent;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.util.DefaultClock;
import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AggregationWarningManager
implements DisposableBean,
InitializingBean {
    private static final String ACKNOWLEDGED_KEY = "ack";
    @VisibleForTesting
    static final String HAD_HAD_A_SINGLE_DIRECTORY_KEY = "hadHadASingleDirectory";
    @VisibleForTesting
    static final String FIRST_CHECK_DATE_MS_KEY = "firstCheckDateMs";
    @VisibleForTesting
    static final String NAMESPACE_KEY = "c.a.c.plugins:confluence-user-rest:";
    private static final Logger log = LoggerFactory.getLogger(AggregationWarningManager.class);
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DarkFeaturesManager darkFeaturesManager;
    private final EventPublisher eventPublisher;
    private Clock clock = new DefaultClock();
    private final AtomicBoolean databaseLocked = new AtomicBoolean();

    @Autowired
    public AggregationWarningManager(@ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport DarkFeaturesManager darkFeaturesManager, @ComponentImport EventPublisher eventPublisher) {
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
        this.crowdDirectoryService = crowdDirectoryService;
        this.darkFeaturesManager = darkFeaturesManager;
        this.eventPublisher = eventPublisher;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    public boolean shouldShow(String username) {
        return (Boolean)this.transactionTemplate.execute(() -> this.executeShouldShow(username));
    }

    @EventListener
    public void handleEvent(AbstractRestoreEvent abstractRestoreEvent) {
        if (abstractRestoreEvent instanceof RestoreLockDatabaseEvent) {
            this.databaseLocked.set(true);
        } else if (abstractRestoreEvent instanceof RestoreUnlockDatabaseEvent) {
            this.databaseLocked.set(false);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private boolean executeShouldShow(String username) {
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null) {
            return false;
        }
        if (!this.permissionManager.isSystemAdministrator(user)) {
            return false;
        }
        if (this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled("always-show-aggregation-warning")) {
            return true;
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        if (this.isThirtyDaysAfterFirstCheck(pluginSettings)) {
            return false;
        }
        if (!this.hasMultipleEnabledDirectories(pluginSettings)) {
            return false;
        }
        return !this.isUserAcknowledged(user);
    }

    private boolean hasMultipleEnabledDirectories(PluginSettings pluginSettings) {
        String singleDirectoryStr = (String)pluginSettings.get(this.namespaceKey(HAD_HAD_A_SINGLE_DIRECTORY_KEY));
        if (singleDirectoryStr == null || !Boolean.parseBoolean(singleDirectoryStr)) {
            int activeDirectoryCount = 0;
            for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
                if (!directory.isActive() || ++activeDirectoryCount < 2) continue;
                return true;
            }
            if (activeDirectoryCount == 1 && !this.databaseLocked.get()) {
                pluginSettings.put(this.namespaceKey(HAD_HAD_A_SINGLE_DIRECTORY_KEY), (Object)Boolean.TRUE.toString());
            }
            return false;
        }
        return false;
    }

    private boolean isThirtyDaysAfterFirstCheck(PluginSettings pluginSettings) {
        DateTime now = new DateTime((Object)this.clock.getCurrentDate());
        String firstCheckStr = (String)pluginSettings.get(this.namespaceKey(FIRST_CHECK_DATE_MS_KEY));
        if (firstCheckStr == null) {
            if (!this.databaseLocked.get()) {
                pluginSettings.put(this.namespaceKey(FIRST_CHECK_DATE_MS_KEY), (Object)Long.toString(now.toDate().getTime()));
            }
            return false;
        }
        long firstCheck = Long.parseLong(firstCheckStr);
        return firstCheck <= now.minusDays(30).toDate().getTime();
    }

    public ValidationResult setAcknowledged(ConfluenceUser user) {
        return (ValidationResult)this.transactionTemplate.execute(() -> this.executeSetAcknowledged(user));
    }

    private ValidationResult executeSetAcknowledged(ConfluenceUser user) {
        if (!this.permissionManager.isSystemAdministrator(user)) {
            return SimpleValidationResult.builder().authorized(false).build();
        }
        try {
            this.userAccessor.getUserPreferences(user).setLong(this.namespaceKey(ACKNOWLEDGED_KEY), System.currentTimeMillis());
            return SimpleValidationResult.builder().authorized(true).build();
        }
        catch (UserPreferences.PreferenceException ex) {
            log.error("Could not acknowledge directory warning notice, admins may be seeing excessive notifications about aggregation of user directories", (Throwable)ex);
            return SimpleValidationResult.builder().authorized(true).addError(ex.getMessage(), new Object[0]).build();
        }
    }

    private String namespaceKey(String key) {
        return NAMESPACE_KEY + key;
    }

    public boolean isUserAcknowledged(ConfluenceUser user) {
        return this.userAccessor.getUserPreferences(user).getLong(this.namespaceKey(ACKNOWLEDGED_KEY)).orElse(0L) > 0L;
    }
}

