/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.aggregation.rest;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.extras.aggregation.impl.AggregationWarningManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@Path(value="/aggregation-warning")
@Internal
public class InternalAggregationResource {
    private static final int NOT_IMPLEMENTED = 501;
    private final AggregationWarningManager warningManager;

    @Inject
    public InternalAggregationResource(AggregationWarningManager warningManager) {
        this.warningManager = warningManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/disable")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response disable() {
        return Response.status((int)501).entity((Object)"Global disable not yet implemented").build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/acknowledge")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response acknowledge() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ValidationResult result = this.warningManager.setAcknowledged(user);
        if (!result.isAuthorized()) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Need to be authorised as an admin to acknowledge the user group aggregation warning").build();
        }
        if (result.isValid()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
    }
}

