/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;

@JsonRootName(value="user")
public class UserEntity {
    @JsonProperty
    private String username;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;

    private UserEntity(String username, String displayName, boolean active) {
        this.username = username;
        this.displayName = displayName;
        this.active = active;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String displayName;
        private boolean active;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public UserEntity build() {
            return new UserEntity(this.username, this.displayName, this.active);
        }
    }
}

