/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.extras.builders.GroupEntityBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Path(value="/groups")
@Produces(value={"application/json", "application/xml"})
public class GroupsResource {
    private final GroupEntityBuilder groupEntityBuilder;
    private final PermissionManager permissionManager;
    private static final String DEFAULT_MAX_RESULTS_QUERY = "50";

    @Inject
    public GroupsResource(GroupEntityBuilder groupEntityBuilder, @ComponentImport PermissionManager permissionManager) {
        this.groupEntityBuilder = groupEntityBuilder;
        this.permissionManager = permissionManager;
    }

    @GET
    public Response getGroups(@QueryParam(value="startIndex") int startIndex, @DefaultValue(value="50") @QueryParam(value="maxResults") int maxResults) {
        if (this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.ok((Object)this.groupEntityBuilder.getGroups(startIndex, maxResults)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

