/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.features;

import com.atlassian.sal.api.features.SiteDarkFeaturesStorage;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DefaultSiteDarkFeaturesStorage
implements SiteDarkFeaturesStorage {
    private static final String SITE_WIDE_DARK_FEATURES = "atlassian.sitewide.dark.features";
    private final ResettableLazyReference<Set<String>> cache = new ResettableLazyReference<Set<String>>(){

        protected Set<String> create() {
            return ImmutableSet.copyOf(DefaultSiteDarkFeaturesStorage.this.load());
        }
    };
    private final PluginSettingsFactory pluginSettingsFactory;

    public DefaultSiteDarkFeaturesStorage(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public boolean contains(String featureKey) {
        String trimmedFeatureKey = Objects.requireNonNull(StringUtils.trimToNull((String)featureKey), "featureKey must not be blank");
        return ((Set)this.cache.get()).contains(trimmedFeatureKey);
    }

    public void enable(String featureKey) {
        String trimmedFeatureKey = Objects.requireNonNull(StringUtils.trimToNull((String)featureKey), "featureKey must not be blank");
        if (!((Set)this.cache.get()).contains(trimmedFeatureKey)) {
            this.update(this.addFeatureKey(trimmedFeatureKey));
            this.cache.reset();
        }
    }

    public void disable(String featureKey) {
        String trimmedFeatureKey = Objects.requireNonNull(StringUtils.trimToNull((String)featureKey), "featureKey must not be blank");
        if (((Set)this.cache.get()).contains(trimmedFeatureKey)) {
            this.update(this.removeFeatureKey(trimmedFeatureKey));
            this.cache.reset();
        }
    }

    public Set<String> getEnabledDarkFeatureSet() {
        return (Set)this.cache.get();
    }

    private synchronized void update(UnaryOperator<List<String>> transformer) {
        List<String> storedFeatureKeys = this.load();
        List updatedFeatureKeys = (List)transformer.apply(storedFeatureKeys);
        this.store(updatedFeatureKeys);
    }

    private synchronized List<String> load() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = globalSettings.get(SITE_WIDE_DARK_FEATURES);
        return this.extractFeatureKeys(value);
    }

    private List<String> extractFeatureKeys(@Nullable Object value) {
        LinkedList<String> storedFeatureKeys = new LinkedList<String>();
        if (value instanceof List) {
            List list = (List)List.class.cast(value);
            for (Object listItem : list) {
                if (!(listItem instanceof String)) continue;
                storedFeatureKeys.addLast((String)String.class.cast(listItem));
            }
        }
        return storedFeatureKeys;
    }

    private synchronized void store(List<String> updatedFeatureKeys) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(SITE_WIDE_DARK_FEATURES, updatedFeatureKeys);
    }

    private UnaryOperator<List<String>> addFeatureKey(String featureKey) {
        return storedFeatureKeys -> {
            if (storedFeatureKeys == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>((Collection<String>)storedFeatureKeys);
            if (!storedFeatureKeys.contains(featureKey)) {
                result.add(featureKey);
            }
            return result;
        };
    }

    private UnaryOperator<List<String>> removeFeatureKey(String featureKey) {
        return storedFeatureKeys -> {
            if (storedFeatureKeys == null) {
                return storedFeatureKeys;
            }
            ArrayList result = new ArrayList(storedFeatureKeys);
            result.remove(featureKey);
            return result;
        };
    }
}

