/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.logging.log4j.layout;

import com.atlassian.confluence.impl.logging.ConfluenceStackTraceRenderer;
import org.apache.catalina.core.ContainerBase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="ConfluenceStackTrace", category="Converter")
@ConverterKeys(value={"stacktrace"})
public final class Log4j2StackTracePatternConverter
extends LogEventPatternConverter {
    private static final String TOMCAT_LOGGER = ContainerBase.class.getName();
    static final String NAME = "ConfluenceStackTrace";
    static final String STACK_TRACE_PATTERN_KEY = "stacktrace";

    Log4j2StackTracePatternConverter() {
        super(NAME, null);
    }

    public static Log4j2StackTracePatternConverter newInstance(String[] options) {
        return new Log4j2StackTracePatternConverter();
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (event.getThrown() != null && !this.isTomcatServletError(event)) {
            toAppendTo.append(ConfluenceStackTraceRenderer.renderStackTrace((Throwable)event.getThrown()));
        }
    }

    private boolean isTomcatServletError(LogEvent event) {
        return Level.ERROR.equals((Object)event.getLevel()) && event.getLoggerName().startsWith(TOMCAT_LOGGER) && event.getMessage().getFormat().startsWith("Servlet.service()");
    }
}

