/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.email.soy;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.mail.embed.MimeBodyPartRecorder;
import com.atlassian.confluence.mail.embed.MimeBodyPartReference;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class ResourceImageFunction
implements SoyServerFunction<String> {
    public static final ImmutableSet<Integer> VALID_ARG_SIZES = ImmutableSet.builder().add((Object[])new Integer[]{1, 2}).build();
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forCaller();
    private final DataSourceFactory dataSourceFactory;
    private final MimeBodyPartRecorder bodyPartRecorder;

    public ResourceImageFunction(DataSourceFactory dataSourceFactory, MimeBodyPartRecorder bodyPartRecorder) {
        this.dataSourceFactory = dataSourceFactory;
        this.bodyPartRecorder = bodyPartRecorder;
    }

    public String apply(Object ... args) {
        DataSource resource;
        ModuleCompleteKey moduleCompleteKey;
        ModuleCompleteKey moduleCompleteKey2 = moduleCompleteKey = args[0] instanceof ModuleCompleteKey ? (ModuleCompleteKey)args[0] : new ModuleCompleteKey((String)args[0]);
        if (args.length == 2) {
            String resourceName = (String)args[1];
            Optional maybeResource = this.dataSourceFactory.getResourceFromModuleByName(moduleCompleteKey, resourceName);
            if (maybeResource.isEmpty()) {
                log.warnOrDebug("Either the module [%s] or a nested resource with name [%s] does not exist in plugin [%s].", moduleCompleteKey.getModuleKey(), resourceName, moduleCompleteKey.getPluginKey());
                return moduleCompleteKey.getCompleteKey();
            }
            resource = (DataSource)maybeResource.get();
        } else {
            try {
                resource = (DataSource)Iterables.getOnlyElement((Iterable)this.dataSourceFactory.getResourcesFromModules(moduleCompleteKey));
            }
            catch (NoSuchElementException e) {
                log.warnOrDebug("Module [%s] in plugin [%s] is not a resource and does not contain nested resources.", moduleCompleteKey.getModuleKey(), moduleCompleteKey.getPluginKey());
                return moduleCompleteKey.getCompleteKey();
            }
            catch (IllegalArgumentException e) {
                log.warnOrDebug("Module [%s] in plugin [%s] is not a resource, please provide the resource name as a second argument in case it is nested inside the module.", moduleCompleteKey.getModuleKey(), moduleCompleteKey.getPluginKey());
                return moduleCompleteKey.getCompleteKey();
            }
        }
        return ((MimeBodyPartReference)this.bodyPartRecorder.trackSource(resource).get()).getLocator().toASCIIString();
    }

    public String getName() {
        return "resourceImage";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

