/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.email.soy;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.mail.embed.MimeBodyPartRecorder;
import com.atlassian.confluence.mail.embed.MimeBodyPartReference;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceLogoImageFunction
implements SoyServerFunction<String> {
    private static final ImmutableSet<Integer> SIZE = ImmutableSet.of((Object)1);
    private static final Logger log = LoggerFactory.getLogger(SpaceLogoImageFunction.class);
    private final DataSourceFactory dataSourceFactory;
    private final MimeBodyPartRecorder bodyPartRecorder;
    private final SpaceManager spaceManager;

    public SpaceLogoImageFunction(DataSourceFactory dataSourceFactory, MimeBodyPartRecorder bodyPartRecorder, SpaceManager spaceManager) {
        this.dataSourceFactory = dataSourceFactory;
        this.bodyPartRecorder = bodyPartRecorder;
        this.spaceManager = spaceManager;
    }

    public String apply(Object ... args) {
        DataSource spaceLogoDataSource;
        Space spaceObject;
        if (args[0] instanceof com.atlassian.confluence.api.model.content.Space) {
            com.atlassian.confluence.api.model.content.Space space = (com.atlassian.confluence.api.model.content.Space)args[0];
            spaceObject = this.spaceManager.getSpace(space.getId());
        } else if (args[0] instanceof Space) {
            spaceObject = (Space)args[0];
        } else if (args[0] instanceof String) {
            spaceObject = this.spaceManager.getSpace((String)args[0]);
        } else {
            return this.checkArgument(args[0]);
        }
        try {
            spaceLogoDataSource = this.dataSourceFactory.getSpaceLogo(spaceObject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.debug("using avatar datasource {} for space {}[{}]", new Object[]{spaceLogoDataSource.getName(), spaceObject.getName(), spaceObject.getKey()});
        return ((MimeBodyPartReference)this.bodyPartRecorder.trackSource(spaceLogoDataSource).get()).getLocator().toASCIIString();
    }

    private String checkArgument(Object arg) {
        if (arg != null) {
            throw new ClassCastException("argument 0 is not of type '" + Space.class.getName() + "' in '" + this.getName() + "' soy function : " + arg.getClass().getName());
        }
        throw new NullPointerException("argument 0 is null in '" + this.getName() + "' soy function");
    }

    public String getName() {
        return "spaceLogoImage";
    }

    public Set<Integer> validArgSizes() {
        return SIZE;
    }
}

