/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.impl;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.ClearSpecCacheEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.cdn.CdnStrategyProvider;
import com.atlassian.plugins.cdn.api.StaticAssetsProvider;
import com.atlassian.plugins.impl.CdnConfigurationChangedEvent;
import com.atlassian.plugins.impl.PrefixCDNStrategy;
import com.atlassian.plugins.impl.RebuildCachedUrls;
import com.atlassian.plugins.impl.rest.CdnConfigurationEntity;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.inject.Inject;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CdnStrategyProvider.class, StaticAssetsProvider.class})
public class CdnStrategyProviderImpl
implements CdnStrategyProvider,
StaticAssetsProvider {
    private static final Logger log = LoggerFactory.getLogger(CdnStrategyProviderImpl.class);
    public static final String CDN_ENABLED_FEATURE_KEY = "atlassian.cdn.enabled";
    public static final String CDN_URL_FEATURE_KEY = "atlassian.prefix.cdn.url";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;
    private final RebuildCachedUrls rebuildCachedUrls;
    private final CachedReference<Optional<CDNStrategy>> cachedStrategyReference;

    @Inject
    public CdnStrategyProviderImpl(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate, CacheManager cacheManager, EventPublisher eventPublisher, RebuildCachedUrls rebuildCachedUrls) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.rebuildCachedUrls = rebuildCachedUrls;
        this.cachedStrategyReference = cacheManager.getCachedReference(CdnStrategyProviderImpl.class.getName(), this::createCdnStrategy, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().build());
    }

    @PostConstruct
    @PreDestroy
    private void reset() {
        this.cachedStrategyReference.reset();
    }

    public Optional<CDNStrategy> getCdnStrategy() {
        return (Optional)this.cachedStrategyReference.get();
    }

    private Optional<CDNStrategy> createCdnStrategy() {
        return this.isEnabled() ? Optional.of(new PrefixCDNStrategy(this.getUrl())) : Optional.empty();
    }

    @Override
    public boolean isEnabled() {
        return Boolean.valueOf((String)this.pluginSettingsFactory.createGlobalSettings().get(CDN_ENABLED_FEATURE_KEY));
    }

    @Override
    public String getUrl() {
        return (String)this.pluginSettingsFactory.createGlobalSettings().get(CDN_URL_FEATURE_KEY);
    }

    public CdnConfigurationEntity getConfiguration() {
        return new CdnConfigurationEntity(this.isEnabled(), this.getUrl());
    }

    public void setConfiguration(CdnConfigurationEntity configuration) {
        this.transactionTemplate.execute(() -> {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
            pluginSettings.put(CDN_ENABLED_FEATURE_KEY, (Object)String.valueOf(configuration.isEnabled()));
            pluginSettings.put(CDN_URL_FEATURE_KEY, (Object)configuration.getUrl());
            return null;
        });
        this.reset();
        this.clearGadgetSpecCache();
        this.eventPublisher.publish((Object)new CdnConfigurationChangedEvent(configuration.isEnabled(), configuration.getUrl()));
        this.rebuildCachedUrls.run();
    }

    private void clearGadgetSpecCache() {
        try {
            this.eventPublisher.publish((Object)new ClearSpecCacheEvent());
        }
        catch (NoClassDefFoundError e) {
            log.info("Gadgets API not present in product, skipping cache invalidation: " + String.valueOf(e));
        }
    }
}

