/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.browser;

import com.atlassian.analytics.client.TimeKeeper;
import com.atlassian.analytics.client.api.browser.BrowserEvent;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.event.api.EventPublisher;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

@Path(value="/publish")
@AnonymousSiteAccess
public class PublisherResource {
    private final EventPublisher eventPublisher;
    private final TimeKeeper timeKeeper;

    @Inject
    public PublisherResource(EventPublisher eventPublisher, TimeKeeper timeKeeper) {
        this.eventPublisher = eventPublisher;
        this.timeKeeper = timeKeeper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response publishSingleEvent(BrowserEventBean bean) {
        BrowserEvent event = this.toBrowserEvent(bean);
        this.eventPublisher.publish((Object)event);
        return Response.ok().build();
    }

    @Path(value="/bulk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response publishBulkEvents(List<BrowserEventBean> beans) {
        for (BrowserEventBean bean : beans) {
            BrowserEvent event = this.toBrowserEvent(bean);
            this.eventPublisher.publish((Object)event);
        }
        return Response.ok().build();
    }

    private BrowserEvent toBrowserEvent(BrowserEventBean bean) {
        return new BrowserEvent(bean.name, bean.properties, this.timeKeeper.currentTimeMillis() + bean.timeDelta);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class BrowserEventBean {
        @JsonProperty
        String name;
        @JsonProperty
        Map<String, Object> properties;
        @JsonProperty
        long timeDelta;

        BrowserEventBean() {
        }

        BrowserEventBean(String name, Map<String, Object> properties, long timeDelta) {
            this.name = name;
            this.properties = properties;
            this.timeDelta = timeDelta;
        }
    }
}

