/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.eventfilter.parser;

import com.atlassian.analytics.client.eventfilter.reader.FilterListReader;
import com.atlassian.analytics.client.eventfilter.whitelist.FilteredEventAttributes;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonListParser {
    private static final Logger LOG = LoggerFactory.getLogger(JsonListParser.class);
    private final FilterListReader filterListReader;

    public JsonListParser(FilterListReader filterListReader) {
        this.filterListReader = filterListReader;
    }

    public Map<String, FilteredEventAttributes> readJsonFilterList(String filterListName) {
        try {
            return this.readJsonFilterListAndFailOnError(filterListName);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the JSON list {} with error: ", (Object)filterListName, (Object)e);
            return null;
        }
    }

    public Map<String, FilteredEventAttributes> readJsonFilterListAndFailOnError(String filterListName) throws IOException {
        ObjectMapper mapper = this.createObjectMapper();
        InputStream listInputStream = this.filterListReader.readFilterList(filterListName);
        if (listInputStream != null) {
            return (Map)mapper.readValue(listInputStream, (TypeReference)new TypeReference<Map<String, FilteredEventAttributes>>(this){});
        }
        throw new IOException("Couldn't find and read the JSON list " + filterListName);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("StringMappingModule", new Version(1, 0, 0, null));
        module.addDeserializer(String.class, (JsonDeserializer)new NonForgivingStringDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static class NonForgivingStringDeserializer
    extends JsonDeserializer<String> {
        final StringDeserializer stringDeserializer = new StringDeserializer();

        private NonForgivingStringDeserializer() {
        }

        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return this.stringDeserializer.deserialize(jp, ctxt);
        }
    }
}

