/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.eventfilter.whitelist;

import com.atlassian.analytics.client.eventfilter.whitelist.FilteredEventAttributes;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class PluginWhitelistReader {
    private static final Logger log = LoggerFactory.getLogger(PluginWhitelistReader.class);
    private static final List<String> HASH_ATTRIBUTE_NAMES = ImmutableList.of((Object)"user", (Object)"username", (Object)"user.name");

    public Map<String, FilteredEventAttributes> read(InputStream inputStream) throws IOException {
        JsonFactory jf = new JsonFactory();
        jf.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper mapper = new ObjectMapper(jf);
        return this.mapFilteredAttributes((Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, List<Object>>>(this){}));
    }

    public Map<String, FilteredEventAttributes> read(Resource resource) {
        Map<String, FilteredEventAttributes> map;
        block8: {
            InputStream inputStream = resource.getInputStream();
            try {
                map = this.read(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to read the JSON whitelist with error message: {}", (Object)e.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return map;
    }

    private Map<String, FilteredEventAttributes> mapFilteredAttributes(Map<String, List<Object>> attributes) {
        HashMap<String, FilteredEventAttributes> filteredEventAttributesMap = new HashMap<String, FilteredEventAttributes>();
        for (Map.Entry<String, List<Object>> eventAttributesMap : attributes.entrySet()) {
            String eventName = eventAttributesMap.getKey();
            FilteredEventAttributes filteredEventAttributes = (FilteredEventAttributes)filteredEventAttributesMap.get(eventName);
            if (filteredEventAttributes == null) {
                filteredEventAttributes = new FilteredEventAttributes();
                filteredEventAttributesMap.put(eventName, filteredEventAttributes);
            }
            this.setFilteredAttributes(filteredEventAttributes, eventAttributesMap.getValue());
        }
        return filteredEventAttributesMap;
    }

    private void setFilteredAttributes(FilteredEventAttributes filteredEventAttributes, List<Object> attributeValues) {
        ArrayList<String> hashAttributes = new ArrayList<String>();
        ArrayList<String> dictionaryAttributes = new ArrayList<String>();
        HashMap<String, List<String>> allowedPropertyValues = new HashMap<String, List<String>>();
        for (Object value : attributeValues) {
            if (value instanceof Map) {
                Map allowedValues = (Map)value;
                for (Map.Entry allowedValueList : allowedValues.entrySet()) {
                    String propertyName = (String)allowedValueList.getKey();
                    this.addPropertyToFilterList(propertyName, hashAttributes, dictionaryAttributes);
                    allowedPropertyValues.put(propertyName, (List)allowedValueList.getValue());
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            this.addPropertyToFilterList((String)value, hashAttributes, dictionaryAttributes);
        }
        attributeValues.removeAll(hashAttributes);
        if (!hashAttributes.isEmpty()) {
            filteredEventAttributes.setHashedAttributes(hashAttributes);
        }
        if (!attributeValues.isEmpty()) {
            filteredEventAttributes.setDictionaryFilteredAttributes(dictionaryAttributes);
        }
        if (!allowedPropertyValues.isEmpty()) {
            filteredEventAttributes.setAllowedPropertyValues(allowedPropertyValues);
        }
    }

    private void addPropertyToFilterList(String propertyName, List<String> hashAttributes, List<String> dictionaryAttributes) {
        if (HASH_ATTRIBUTE_NAMES.contains(propertyName)) {
            hashAttributes.add(propertyName);
        } else {
            dictionaryAttributes.add(propertyName);
        }
    }
}

