/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHttpFilter
implements Filter {
    static final Integer ZIPKIN_MAX_TRACE_BITS = 56;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
            return;
        }
        filterChain.doFilter(request, response);
    }

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private static String generateTraceId() {
        return Long.toHexString(ThreadLocalRandom.current().nextLong() & (1L << ZIPKIN_MAX_TRACE_BITS) - 1L);
    }

    protected static void setB3TraceId(HttpServletRequest request) {
        if (request.getAttributeNames() == null || !Collections.list(request.getAttributeNames()).contains("B3-TraceId")) {
            request.setAttribute("B3-TraceId", (Object)StringUtils.defaultIfBlank((CharSequence)request.getHeader("X-B3-TraceId"), (CharSequence)AbstractHttpFilter.generateTraceId()));
        }
    }
}

