/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.listener;

import com.atlassian.analytics.api.events.AnalyticsPluginReadyEvent;
import com.atlassian.analytics.api.listener.ProductAnalyticsEventListener;
import com.atlassian.analytics.client.eventfilter.whitelist.WhitelistFilter;
import com.atlassian.analytics.client.featureflag.AnalyticsFeatureFlags;
import com.atlassian.analytics.client.upload.PeriodicEventUploaderScheduler;
import com.atlassian.analytics.client.uuid.ProductUUIDProvider;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import org.springframework.beans.factory.DisposableBean;

public class JiraEventListener
implements DisposableBean,
LifecycleAware {
    private final EventPublisher eventPublisher;
    private final ProductAnalyticsEventListener productAnalyticsEventListener;
    private final PeriodicEventUploaderScheduler periodicEventUploaderScheduler;
    private final WhitelistFilter whitelistFilter;
    private final ProductUUIDProvider productUUIDProvider;
    private final AnalyticsFeatureFlags analyticsFeatureFlags;

    public JiraEventListener(EventPublisher eventPublisher, ProductAnalyticsEventListener productAnalyticsEventListener, PeriodicEventUploaderScheduler periodicEventUploaderScheduler, WhitelistFilter whitelistFilter, ProductUUIDProvider productUUIDProvider, AnalyticsFeatureFlags analyticsFeatureFlags) {
        this.eventPublisher = eventPublisher;
        this.productAnalyticsEventListener = productAnalyticsEventListener;
        this.periodicEventUploaderScheduler = periodicEventUploaderScheduler;
        this.whitelistFilter = whitelistFilter;
        this.productUUIDProvider = productUUIDProvider;
        this.analyticsFeatureFlags = analyticsFeatureFlags;
    }

    public void onStart() {
        this.productUUIDProvider.createUUID();
        this.whitelistFilter.collectExternalWhitelists();
        this.eventPublisher.register((Object)this);
        this.eventPublisher.publish((Object)new AnalyticsPluginReadyEvent());
    }

    @EventListener
    public void onEvent(Object event) {
        if (event instanceof ComponentManagerShutdownEvent) {
            this.periodicEventUploaderScheduler.unscheduleJobs();
            this.destroy();
            return;
        }
        this.productAnalyticsEventListener.processEvent(event);
    }

    @EventListener
    public void onUpgradeComplete(JiraUpgradedEvent event) {
        this.analyticsFeatureFlags.invalidateCache();
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void onStop() {
    }
}

