/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.logger;

import com.atlassian.analytics.client.properties.LoggingProperties;
import com.atlassian.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

class AnalyticsLoggerConfigurationBuilder {
    public static final String APPENDER_SUFFIX = ".rolling";
    private static final String APPENDER_FILE_NAME_ATTRIBUTE = "fileName";
    private static final String APPENDER_FILE_PATTERN_ATTRIBUTE = "filePattern";
    private static final String APPENDER_PLUGIN_NAME = "RollingFile";
    @VisibleForTesting
    static final String CONFIGURATION_BUILDER_NAME = "AnalyticsLoggerConfiguration";
    private static final String LAYOUT_PLUGIN_NAME = "PatternLayout";
    private static final String LAYOUT_PATTERN_ATTRIBUTE = "pattern";
    private static final String LOGGER_ADDITIVITY_ATTRIBUTE = "additivity";
    private static final String POLICIES_PLUGIN_NAME = "Policies";
    private static final String SIZED_BASED_TRIGGERING_POLICY_PLUGIN_NAME = "SizeBasedTriggeringPolicy";
    private static final String SIZED_BASED_TRIGGERING_POLICY_SIZE_ATTRIBUTE = "size";
    private static final String ROLLING_OVER_STRATEGY = "DefaultRolloverStrategy";
    private static final String ROLLING_OVER_STRATEGY_MAX_FILE_NUMBER_ATTRIBUTE = "max";
    private static final String TIME_BASED_TRIGGERING_POLICY_PLUGIN_NAME = "TimeBasedTriggeringPolicy";
    private static final String TIME_BASED_TRIGGERING_POLICY_INTERVAL_ATTRIBUTE = "interval";
    private static final String CONSOLE_APPENDER_NAME = "Stdout";
    private static final String CONSOLE_APPENDER_PLUGIN_NAME = "CONSOLE";
    private static final String CONSOLE_APPENDER_TARGET_ATTRIBUTE = "target";
    private static final String ROOT_LOGGER_PATTERN = "%d [%t] %-5level: %msg%n%throwable";
    private static final String CANNOT_FIND_APPENDER_BUILDER_FOR_LOGGER = "Cannot find appenderBuilder for logger %s";
    private static final String LOGGER_NAME_MANDATORY = "The logger name is mandatory";
    private static final int NUMBER_OF_LOGGERS = 2;
    private final ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
    private final Map<String, AppenderComponentBuilder> appenderBuilders = new HashMap<String, AppenderComponentBuilder>(2);
    private final Map<String, LoggerComponentBuilder> loggerBuilders;
    private final Map<String, ComponentBuilder<?>> policiesComponentBuilders;
    private final Map<String, Collection<ComponentBuilder<?>>> triggeringPolicyBuilders;

    AnalyticsLoggerConfigurationBuilder() {
        this.addAppenderBuilder("com.atlassian.analytics.client.btflogger");
        this.addAppenderBuilder("com.atlassian.analytics.client.btflogger.connectivity.check");
        this.loggerBuilders = new HashMap<String, LoggerComponentBuilder>(2);
        this.addLoggerBuilder("com.atlassian.analytics.client.btflogger");
        this.addLoggerBuilder("com.atlassian.analytics.client.btflogger.connectivity.check");
        this.policiesComponentBuilders = new HashMap(2);
        this.addPoliciesComponentBuilder("com.atlassian.analytics.client.btflogger");
        this.addPoliciesComponentBuilder("com.atlassian.analytics.client.btflogger.connectivity.check");
        this.triggeringPolicyBuilders = new HashMap(2);
        this.addTriggeringPoliciesCollection("com.atlassian.analytics.client.btflogger");
        this.addTriggeringPoliciesCollection("com.atlassian.analytics.client.btflogger.connectivity.check");
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withAppenderFileName(@Nonnull String loggerName, @Nonnull String fileName) {
        Objects.requireNonNull(loggerName, LOGGER_NAME_MANDATORY);
        Objects.requireNonNull(fileName, "The file name is mandatory");
        AppenderComponentBuilder appenderBuilder = this.appenderBuilders.get(loggerName);
        Objects.requireNonNull(appenderBuilder, String.format(CANNOT_FIND_APPENDER_BUILDER_FOR_LOGGER, loggerName));
        appenderBuilder.addAttribute(APPENDER_FILE_NAME_ATTRIBUTE, fileName);
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withAppenderFilePattern(@Nonnull String loggerName, @Nonnull String filePattern) {
        Objects.requireNonNull(loggerName, LOGGER_NAME_MANDATORY);
        Objects.requireNonNull(filePattern, "The file pattern is mandatory");
        AppenderComponentBuilder appenderBuilder = this.appenderBuilders.get(loggerName);
        Objects.requireNonNull(appenderBuilder, String.format(CANNOT_FIND_APPENDER_BUILDER_FOR_LOGGER, loggerName));
        appenderBuilder.addAttribute(APPENDER_FILE_PATTERN_ATTRIBUTE, filePattern);
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withAppenderRolloverStrategy() {
        Object rolloverStrategy = this.builder.newComponent(ROLLING_OVER_STRATEGY).addAttribute(ROLLING_OVER_STRATEGY_MAX_FILE_NUMBER_ATTRIBUTE, LoggingProperties.MAX_ROLL_FILE_COUNT);
        this.appenderBuilders.values().forEach(appenderBuilder -> appenderBuilder.addComponent((ComponentBuilder<?>)rolloverStrategy));
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withTimeBasedTriggeringPolicy(int interval) {
        Object triggeringPolicy = this.builder.newComponent(TIME_BASED_TRIGGERING_POLICY_PLUGIN_NAME).addAttribute(TIME_BASED_TRIGGERING_POLICY_INTERVAL_ATTRIBUTE, interval);
        this.triggeringPolicyBuilders.values().forEach(policyBuilder -> policyBuilder.add(triggeringPolicy));
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withSizeBasedTriggeringPolicy(String loggerName, Long size, String sizeUnitSuffix) {
        Objects.requireNonNull(loggerName, LOGGER_NAME_MANDATORY);
        Objects.requireNonNull(size, "The size parameter is mandatory");
        Collection<ComponentBuilder<?>> policyBuilder = this.triggeringPolicyBuilders.get(loggerName);
        Objects.requireNonNull(policyBuilder, String.format("Cannot find policyBuilder for logger %s", loggerName));
        Object policySize = size.toString();
        if (sizeUnitSuffix != null) {
            policySize = (String)policySize + " " + sizeUnitSuffix;
        }
        Object triggeringPolicy = this.builder.newComponent(SIZED_BASED_TRIGGERING_POLICY_PLUGIN_NAME).addAttribute(SIZED_BASED_TRIGGERING_POLICY_SIZE_ATTRIBUTE, (String)policySize);
        policyBuilder.add((ComponentBuilder<?>)triggeringPolicy);
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withLayoutPattern(@Nonnull String pattern) {
        Objects.requireNonNull(pattern, "The layout pattern is mandatory");
        LayoutComponentBuilder layoutBuilder = this.builder.newLayout(LAYOUT_PLUGIN_NAME);
        layoutBuilder.addAttribute(LAYOUT_PATTERN_ATTRIBUTE, pattern);
        this.appenderBuilders.values().forEach(appenderBuilder -> appenderBuilder.add(layoutBuilder));
        return this;
    }

    @Nonnull
    AnalyticsLoggerConfigurationBuilder withLoggerAdditivity() {
        this.loggerBuilders.values().forEach(logger -> logger.addAttribute(LOGGER_ADDITIVITY_ATTRIBUTE, false));
        return this;
    }

    @Nonnull
    Configuration build() {
        this.builder.setConfigurationName(CONFIGURATION_BUILDER_NAME);
        this.builder.setStatusLevel(Level.INFO);
        this.appenderBuilders.forEach((key, appenderBuilder) -> {
            ComponentBuilder<?> policyBuilder = this.policiesComponentBuilders.get(key);
            Objects.requireNonNull(policyBuilder, String.format("Cannot find policyBuilder for logger %s", key));
            Collection<ComponentBuilder<?>> triggeringPolicyBuilder = this.triggeringPolicyBuilders.get(key);
            Objects.requireNonNull(triggeringPolicyBuilder, String.format("Cannot find triggeringPolicyBuilder for logger %s", key));
            triggeringPolicyBuilder.forEach(policyBuilder::addComponent);
            appenderBuilder.addComponent(policyBuilder);
            this.builder.add((AppenderComponentBuilder)appenderBuilder);
        });
        this.loggerBuilders.values().forEach(loggerBuilder -> {
            String loggerName = loggerBuilder.getName();
            AppenderComponentBuilder appenderBuilder = this.appenderBuilders.get(loggerName);
            Objects.requireNonNull(appenderBuilder, String.format(CANNOT_FIND_APPENDER_BUILDER_FOR_LOGGER, loggerName));
            this.builder.add((LoggerComponentBuilder)loggerBuilder.add(this.builder.newAppenderRef(appenderBuilder.getName())));
        });
        this.configureErrorLevelConsoleAppender();
        return (Configuration)this.builder.build();
    }

    private void configureErrorLevelConsoleAppender() {
        AppenderComponentBuilder consoleAppenderBuilder = (AppenderComponentBuilder)this.builder.newAppender(CONSOLE_APPENDER_NAME, CONSOLE_APPENDER_PLUGIN_NAME).addAttribute(CONSOLE_APPENDER_TARGET_ATTRIBUTE, ConsoleAppender.Target.SYSTEM_OUT);
        consoleAppenderBuilder.add((LayoutComponentBuilder)this.builder.newLayout(LAYOUT_PLUGIN_NAME).addAttribute(LAYOUT_PATTERN_ATTRIBUTE, ROOT_LOGGER_PATTERN));
        this.builder.add(consoleAppenderBuilder);
        this.builder.add((RootLoggerComponentBuilder)this.builder.newRootLogger(Level.ERROR).add(this.builder.newAppenderRef(CONSOLE_APPENDER_NAME)));
    }

    private void addAppenderBuilder(String loggerName) {
        String appenderName = loggerName + APPENDER_SUFFIX;
        this.appenderBuilders.put(loggerName, this.builder.newAppender(appenderName, APPENDER_PLUGIN_NAME));
    }

    private void addLoggerBuilder(String loggerName) {
        this.loggerBuilders.put(loggerName, this.builder.newLogger(loggerName, Level.INFO));
    }

    private void addPoliciesComponentBuilder(String loggerName) {
        this.policiesComponentBuilders.put(loggerName, this.builder.newComponent(POLICIES_PLUGIN_NAME));
    }

    private void addTriggeringPoliciesCollection(String loggerName) {
        this.triggeringPolicyBuilders.put(loggerName, new ArrayList(2));
    }
}

