/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.properties;

import com.atlassian.analytics.client.properties.AnalyticsPropertyService;
import com.atlassian.analytics.client.properties.ProductProperties;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingProperties {
    static final Logger LOG = LoggerFactory.getLogger(LoggingProperties.class);
    static final String MAX_ROLL_FILE_COUNT_KEY = "analytics.logger.max.roll.file.count";
    static final String MAX_FILE_SIZE_KEY = "analytics.logger.max.file.size";
    static final String MAX_LOGS_DIR_SIZE_KEY = "analytics.max.logs.dir.size";
    static final ImmutableMap<String, Long> DEFAULT_VALUES = ImmutableMap.of((Object)"analytics.logger.max.roll.file.count", (Object)100L, (Object)"analytics.logger.max.file.size", (Object)50L, (Object)"analytics.max.logs.dir.size", (Object)100L);
    public static final String ANALYTICS_LOGGER_NAME = "com.atlassian.analytics.client.btflogger";
    public static final String ANALYTICS_LOG_FILE_EXTENSION = ".atlassian-analytics.log";
    public static final String CONNECTIVITY_CHECK_LOGGER_NAME = "com.atlassian.analytics.client.btflogger.connectivity.check";
    public static final String CONNECTIVITY_CHECK_LOG_FILE_EXTENSION = ".atlassian-analytics-connectivity-check.log";
    public static final long CONNECTIVITY_CHECK_MAX_FILE_SIZE_B = 1L;
    public static final String ANALYTICS_LOG_ROLLING_DATE_PATTERN = "'.'yyyy-MM-dd";
    public static final String ANALYTICS_LOGS_DIR = "analytics-logs";
    public static final int MAX_FILE_SIZE_MAX_VALUE = 1024;
    public static final long MAX_ROLL_FILE_COUNT = LoggingProperties.getValue("analytics.logger.max.roll.file.count");
    public static final long MAX_FILE_SIZE_MB = LoggingProperties.getValue("analytics.logger.max.file.size", 1024);
    public static final long MAX_LOGS_DIR_SIZE_GB = LoggingProperties.getValue("analytics.max.logs.dir.size");
    public static final String POLICY_SIZE_SUFFIX_MB = "MB";
    private final String absoluteLogDirectoryPath;
    private final String logPath;
    private final String connectivityLogPath;

    public LoggingProperties(ProductProperties productInformation, AnalyticsPropertyService applicationProperties) {
        this.absoluteLogDirectoryPath = this.getAbsoluteLogDirectoryPath(applicationProperties);
        this.logPath = this.getLogPath(productInformation, ANALYTICS_LOG_FILE_EXTENSION);
        this.connectivityLogPath = this.getLogPath(productInformation, CONNECTIVITY_CHECK_LOG_FILE_EXTENSION);
    }

    private String getAbsoluteLogDirectoryPath(AnalyticsPropertyService applicationProperties) {
        Objects.requireNonNull(applicationProperties, "The application properties is mandatory.");
        return applicationProperties.getHomeDirectoryAbsolutePath().map(homeDirectoryPath -> new File((String)homeDirectoryPath, ANALYTICS_LOGS_DIR)).map(File::getAbsolutePath).orElse("");
    }

    private String getLogPath(ProductProperties productInformation, String logFileName) {
        Objects.requireNonNull(productInformation, "The product information is mandatory.");
        return Optional.ofNullable(productInformation.getUniqueServerId()).map(uniqueServerId -> uniqueServerId.concat(logFileName)).map(logFilePath -> new File(this.absoluteLogDirectoryPath, (String)logFilePath)).map(File::getAbsolutePath).orElse("");
    }

    @Nonnull
    public String getLogPath() {
        return this.logPath;
    }

    @Nonnull
    public String getConnectivityCheckLogPath() {
        return this.connectivityLogPath;
    }

    @Nonnull
    public String getAbsoluteLogDirectoryPath() {
        return this.absoluteLogDirectoryPath;
    }

    public static long getMaxLogsDirSizeBytes() {
        return (long)((double)MAX_LOGS_DIR_SIZE_GB * Math.pow(2.0, 30.0));
    }

    static long getValue(String key, int maxValue) {
        long value = LoggingProperties.getValue(key);
        if (value > (long)maxValue) {
            value = LoggingProperties.setToDefaultWithWarning(key, String.format("%s %d is higher than maximum allowed value: %d", key, value, maxValue));
        }
        return value;
    }

    static long getValue(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            return LoggingProperties.getDefault(key);
        }
        return LoggingProperties.tryParseLong(key, property);
    }

    private static long tryParseLong(String key, String property) {
        try {
            long value = Long.parseLong(property);
            LoggingProperties.validateIfIsPositiveValue(value);
            return value;
        }
        catch (NumberFormatException exception) {
            return LoggingProperties.setToDefaultWithWarning(key, exception.getMessage());
        }
    }

    private static long setToDefaultWithWarning(String key, String message) {
        LOG.warn("System property {} is required to be a positive non zero integer value. {}", (Object)key, (Object)message);
        return LoggingProperties.getDefault(key);
    }

    private static long getDefault(String key) {
        LOG.info("Using default value {} for {}", DEFAULT_VALUES.get((Object)key), (Object)key);
        return (Long)DEFAULT_VALUES.get((Object)key);
    }

    private static void validateIfIsPositiveValue(long value) {
        if (Long.signum(value) < 1) {
            throw new NumberFormatException(value + " is not a positive value.");
        }
    }
}

