/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.upload;

import com.atlassian.analytics.client.base.BaseDataLogger;
import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.eventfilter.BlacklistFilter;
import com.atlassian.analytics.client.hash.AnalyticsEmailHasher;
import com.atlassian.analytics.client.upload.AbstractRunner;
import com.atlassian.analytics.client.upload.PeriodicEventUploaderScheduler;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import jakarta.annotation.Nullable;

public class RemoteFilterReadRunner
extends AbstractRunner {
    public static final JobId JobId = RemoteFilterReadRunner.getJobId(RemoteFilterReadRunner.class);
    public static final JobRunnerKey JobRunnerKey = RemoteFilterReadRunner.getJobRunnerKey(RemoteFilterReadRunner.class);
    private final PeriodicEventUploaderScheduler scheduler;
    private final BlacklistFilter blacklistFilter;
    private final BaseDataLogger baseDataLogger;
    private final AnalyticsConfig analyticsConfig;
    private final AnalyticsEmailHasher analyticsEmailHasher;

    public RemoteFilterReadRunner(PeriodicEventUploaderScheduler scheduler, BlacklistFilter blacklistFilter, BaseDataLogger baseDataLogger, AnalyticsConfig analyticsConfig, AnalyticsEmailHasher analyticsEmailHasher) {
        this.scheduler = scheduler;
        this.blacklistFilter = blacklistFilter;
        this.baseDataLogger = baseDataLogger;
        this.analyticsConfig = analyticsConfig;
        this.analyticsEmailHasher = analyticsEmailHasher;
    }

    public JobRunnerResponse runJob(@Nullable JobRunnerRequest jobRunnerRequest) {
        this.logger.debug("Executing analytics remote reader job.");
        this.scheduler.scheduleJob(PeriodicEventUploaderScheduler.JobType.REMOTE_FILTER_READ);
        if (this.analyticsConfig.canCollectAnalytics()) {
            this.analyticsEmailHasher.readRemoteInstructions();
            this.blacklistFilter.readRemoteList();
            if (!this.analyticsConfig.hasLoggedBaseData()) {
                this.baseDataLogger.logBaseData();
                this.analyticsConfig.setLoggedBaseData(true);
            }
        }
        return JobRunnerResponse.success();
    }
}

