/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.upload;

import com.atlassian.analytics.api.events.AnalyticsConnectivityCheckEvent;
import com.atlassian.analytics.client.listener.SafeSalRequestProvider;
import com.atlassian.analytics.client.logger.AnalyticsConnectivityCheckLogger;
import com.atlassian.analytics.client.pipeline.preprocessor.EventPreprocessor;
import com.atlassian.analytics.client.pipeline.serialize.EventSerializer;
import com.atlassian.analytics.client.pipeline.serialize.RequestInfo;
import com.atlassian.analytics.client.s3.AnalyticsS3Client;
import com.atlassian.analytics.client.s3.S3UploadException;
import com.atlassian.analytics.client.session.SessionIdProvider;
import com.atlassian.analytics.client.upload.AnalyticsGzLogFileDetector;
import com.atlassian.analytics.client.upload.EventUploaderConfigurationProvider;
import com.atlassian.analytics.event.ProcessedEvent;
import com.atlassian.analytics.event.RawEvent;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.web.context.HttpContext;
import java.io.File;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ConnectivityChecker {
    private static final String I18N_KEY_FAIL_TIP = "analytics.configuration.test.data.sharing.result.failed.tip";
    private static final String FAIL_TIP_ANCHOR_OPEN = "<a href=\"https://confluence.atlassian.com/display/ENTERPRISE/Sharing+usage+data+in+Data+Center\" target=\"_blank\">";
    private static final String FAIL_TIP_ANCHOR_CLOSE = "</a>";
    private static final Logger LOG = LoggerFactory.getLogger(S3ConnectivityChecker.class);
    private final AnalyticsConnectivityCheckLogger analyticsConnectivityCheckLogger;
    private final EventSerializer eventSerializer;
    private final EventPreprocessor eventPreprocessor;
    private final HttpContext httpContext;
    private final SessionIdProvider sessionIdProvider;
    private final EventUploaderConfigurationProvider eventUploaderConfigurationProvider;
    private final AnalyticsS3Client analyticsS3Client;
    private final I18nResolver i18nResolver;

    public S3ConnectivityChecker(AnalyticsConnectivityCheckLogger analyticsConnectivityCheckLogger, EventSerializer eventSerializer, EventPreprocessor eventPreprocessor, HttpContext httpContext, SessionIdProvider sessionIdProvider, EventUploaderConfigurationProvider eventUploaderConfigurationProvider, AnalyticsS3Client analyticsS3Client, I18nResolver i18nResolver) {
        this.analyticsConnectivityCheckLogger = analyticsConnectivityCheckLogger;
        this.eventSerializer = eventSerializer;
        this.eventPreprocessor = eventPreprocessor;
        this.httpContext = httpContext;
        this.sessionIdProvider = sessionIdProvider;
        this.eventUploaderConfigurationProvider = eventUploaderConfigurationProvider;
        this.analyticsS3Client = analyticsS3Client;
        this.i18nResolver = i18nResolver;
    }

    public boolean isS3Accessible() throws S3UploadException {
        int filesUploaded;
        RequestInfo requestInfo = RequestInfo.fromRequest(new SafeSalRequestProvider(this.httpContext).getHttpRequest());
        String sessionId = this.sessionIdProvider.getSessionId();
        AnalyticsConnectivityCheckEvent analyticsConnectivityCheckEvent = new AnalyticsConnectivityCheckEvent();
        Supplier<RawEvent> rawEventSupplier = this.eventSerializer.toAnalyticsEvent(analyticsConnectivityCheckEvent, sessionId, requestInfo);
        ProcessedEvent processedEvent = this.eventPreprocessor.preprocess(rawEventSupplier.get());
        this.analyticsConnectivityCheckLogger.logEvent(processedEvent);
        this.analyticsConnectivityCheckLogger.reset();
        int waitIncrementMs = 100;
        int maxWaitTimeMs = 2000;
        List<Object> logFiles = Collections.emptyList();
        for (int waitedMs = 0; waitedMs < 2000 && (logFiles = this.getLogFiles()).isEmpty(); waitedMs += 100) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.debug("Thread interrupted while sleeping: {}", (Object)e.getMessage());
            }
        }
        if (logFiles.isEmpty()) {
            String message = this.i18nResolver.getText("analytics.configuration.test.data.sharing.result.failed.no.files");
            LOG.error(message);
            throw new S3UploadException(message, null);
        }
        if (logFiles.size() > 1) {
            LOG.error("Found more than one log file to upload: {}", logFiles);
        }
        try {
            filesUploaded = this.analyticsS3Client.uploadFilesToS3Bucket(logFiles, this.eventUploaderConfigurationProvider.getAnalyticsS3BucketName(), this.eventUploaderConfigurationProvider.getAnalyticsS3FolderKeyPrefix());
        }
        catch (S3UploadException e) {
            String message = this.i18nResolver.getText(I18N_KEY_FAIL_TIP);
            message = MessageFormat.format(message, FAIL_TIP_ANCHOR_OPEN, FAIL_TIP_ANCHOR_CLOSE);
            throw new S3UploadException(message, e);
        }
        finally {
            logFiles.forEach(logFile -> {
                try {
                    Files.delete(logFile.toPath());
                }
                catch (Exception e) {
                    LOG.error("Couldn't delete the log file {} during cleanup: {}", (Object)logFile.getAbsolutePath(), (Object)e.getMessage());
                }
            });
        }
        return filesUploaded == 1;
    }

    private List<File> getLogFiles() {
        File logDir = this.eventUploaderConfigurationProvider.getLogDirPath();
        if (!logDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = logDir.listFiles();
        if (files == null) {
            LOG.error("can't list files in log directory usually this indicates failed security manager check or invalid path");
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(AnalyticsGzLogFileDetector::isConnectivityCheckGzLogFile).toList();
    }
}

