/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.confluence.impl.sitemesh.ConfluencePageDecorator;
import com.atlassian.confluence.impl.sitemesh.PageDecoratorFactory;
import com.atlassian.confluence.impl.sitemesh.VelocitySitemeshPage;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.DefaultSitemeshBuffer;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.SitemeshBuffer;
import com.opensymphony.module.sitemesh.parser.AbstractPage;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.Content2HTMLPage;
import com.opensymphony.sitemesh.compatability.HTMLPage2Content;
import com.opensymphony.sitemesh.compatability.OldDecorator2NewDecorator;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.BaseWebAppDecorator;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceDecoratorSelector
implements DecoratorSelector {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceDecoratorSelector.class);
    private final DecoratorMapper decoratorMapper;
    private final DispatcherType dispatcherType;
    private final Supplier<Decorator> fallbackDecoratorFactory;
    private final PageDecoratorFactory pageDecoratorFactory;

    public ConfluenceDecoratorSelector(PageDecoratorFactory pageDecoratorFactory, DecoratorMapper decoratorMapper, DispatcherType dispatcherType, Supplier<Decorator> fallbackDecoratorFactory) {
        this.pageDecoratorFactory = pageDecoratorFactory;
        this.decoratorMapper = decoratorMapper;
        this.dispatcherType = dispatcherType;
        this.fallbackDecoratorFactory = fallbackDecoratorFactory;
    }

    public Decorator selectDecorator(Content content, SiteMeshContext context) {
        HttpServletRequest request = ((SiteMeshWebAppContext)context).getRequest();
        com.opensymphony.module.sitemesh.Decorator decorator = this.decoratorMapper.getDecorator(request, (Page)new Content2HTMLPage(content, request));
        if (decorator == null || decorator.getPage() == null) {
            this.diagnostics(content, context);
            return this.fallbackDecoratorFactory.get();
        }
        if (request.getParameter("sitemeshDispatcher") == null) {
            ConfluencePageDecorator pageDecorator = this.pageDecoratorFactory.createPageDecorator(decorator.getName(), URI.create(decorator.getPage()), this.dispatcherType);
            return this.asSitemeshDecorator(pageDecorator);
        }
        return new OldDecorator2NewDecorator(decorator);
    }

    private Decorator asSitemeshDecorator(final ConfluencePageDecorator delegate) {
        return new BaseWebAppDecorator(this){

            protected void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteMeshWebAppContext webAppContext) throws IOException, ServletException {
                VelocitySitemeshPage page = new VelocitySitemeshPage((HTMLPage)new Content2HTMLPage(content, request));
                request.setAttribute(RequestConstants.PAGE, (Object)page);
                delegate.render(page, request, response);
                request.removeAttribute(RequestConstants.PAGE);
            }
        };
    }

    private void diagnostics(Content content, SiteMeshContext context) {
        HTMLPage page;
        if (log.isDebugEnabled() && content instanceof HTMLPage2Content && (page = this.privateGet(content, HTMLPage2Content.class, "page", HTMLPage.class)) != null) {
            if (page instanceof AbstractPage) {
                SitemeshBuffer buffer = this.privateGet(page, AbstractPage.class, "sitemeshBuffer", SitemeshBuffer.class);
                if (buffer != null) {
                    if (buffer instanceof DefaultSitemeshBuffer) {
                        log.debug("Outputting non decorated page for " + ((SiteMeshWebAppContext)context).getRequest().getRequestURI() + " with buffer length: " + buffer.getBufferLength() + ", total length: " + buffer.getTotalLength() + ", has fragments: " + buffer.hasFragments() + ", and actual buffer length: " + buffer.getCharArray().length);
                        if (log.isTraceEnabled()) {
                            StringWriter writer = new StringWriter();
                            try {
                                buffer.writeTo((Writer)writer, 0, buffer.getBufferLength());
                            }
                            catch (IOException e) {
                                log.error("Error writing out to memory buffer?", (Throwable)e);
                            }
                            String str = writer.toString();
                            log.trace("Page content with length( {}) is:\n{}", (Object)str.length(), (Object)str);
                        }
                    } else {
                        log.debug("Non sitemesh buffer: {}", (Object)buffer.getClass().getName());
                    }
                }
            } else {
                log.debug("Non abstract page: {}", (Object)page.getClass().getName());
            }
        }
    }

    private <C> C privateGet(Object object, Class<?> fieldClass, String fieldName, Class<C> fieldType) {
        try {
            Field field = fieldClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return fieldType.cast(field.get(object));
        }
        catch (Exception e) {
            log.debug("Unable to get field {} from {}", new Object[]{fieldName, object.getClass().getName(), e});
            return null;
        }
    }
}

