/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.NoDecorator;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfluenceSitemeshNoDecorator
extends NoDecorator {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceSitemeshNoDecorator.class);
    private final Charset charset;

    public ConfluenceSitemeshNoDecorator(Charset charset) {
        this.charset = charset;
    }

    protected void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteMeshWebAppContext webAppContext) throws IOException, ServletException {
        if (webAppContext.isUsingStream()) {
            logger.debug("Render content using Stream");
            PrintWriter writer = this.getPrintWriter((OutputStream)response.getOutputStream());
            content.writeOriginal((Writer)writer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            logger.debug("Render content using Writer");
            PrintWriter writer = response.getWriter();
            content.writeOriginal((Writer)writer);
            response.getWriter().flush();
        }
    }

    private PrintWriter getPrintWriter(OutputStream outputStream) {
        if (Charset.defaultCharset().equals(this.charset)) {
            logger.debug("Confluence will use OS default Charset {}", (Object)this.charset);
        }
        return new PrintWriter(new OutputStreamWriter(outputStream, this.charset));
    }
}

