/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.sitemesh;

import com.atlassian.plugin.ModuleDescriptor;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class PluginDecoratorMapper<M>
extends AbstractDecoratorMapper {
    private final Function<M, URI> decoratorUriFactory;
    private final Function<M, String> decoratorNameFactory;
    private final BiPredicate<M, HttpServletRequest> decoratorPathMatcher;
    private final Supplier<Collection<? extends ModuleDescriptor<M>>> moduleDescriptorsRef;

    public PluginDecoratorMapper(Function<M, String> decoratorNameFactory, Function<M, URI> decoratorUriFactory, Supplier<Collection<? extends ModuleDescriptor<M>>> moduleDescriptorsRef, BiPredicate<M, HttpServletRequest> decoratorPathMatcher) {
        this.decoratorUriFactory = decoratorUriFactory;
        this.decoratorNameFactory = decoratorNameFactory;
        this.decoratorPathMatcher = decoratorPathMatcher;
        this.moduleDescriptorsRef = moduleDescriptorsRef;
    }

    public Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        return this.findDecorator(descriptor -> this.decoratorPathMatcher.test(descriptor.getModule(), httpServletRequest)).orElseGet(() -> super.getDecorator(httpServletRequest, page));
    }

    public Decorator getNamedDecorator(HttpServletRequest httpServletRequest, String name) {
        return this.findDecorator(descriptor -> name.equals(descriptor.getName())).orElseGet(() -> super.getNamedDecorator(httpServletRequest, name));
    }

    private Optional<Decorator> findDecorator(Predicate<ModuleDescriptor<M>> filter) {
        return this.moduleDescriptorsRef.get().stream().filter(filter).map(this::createDecorator).findFirst();
    }

    private Decorator createDecorator(ModuleDescriptor<M> descriptor) {
        return this.createDecorator(this.decoratorNameFactory.apply(descriptor.getModule()), this.decoratorUriFactory.apply(descriptor.getModule()));
    }

    private Decorator createDecorator(String name, URI uri) {
        return new DefaultDecorator(name, uri.toString(), null);
    }
}

