/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.impl.struts.ClassExtractor;
import com.atlassian.confluence.impl.struts.OgnlAllowListConfigurator;
import com.atlassian.security.serialblocklist.struts.BlocklistAwareSecureMembersAccess;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.Lazy;
import java.util.function.Supplier;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.ognl.ProviderAllowlist;
import org.apache.struts2.ognl.ThreadAllowlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSecurityMemberAccess
extends BlocklistAwareSecureMembersAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceSecurityMemberAccess.class);
    private final Supplier<OgnlAllowListConfigurator> ognlAllowListConfigurator = Lazy.supplier(() -> (OgnlAllowListConfigurator)ContainerManager.getComponent((String)"ognlAllowListConfigurator", OgnlAllowListConfigurator.class));
    private ClassExtractor classExtractor = new ClassExtractor();

    @Inject
    public ConfluenceSecurityMemberAccess(@Inject ProviderAllowlist providerAllowlist, @Inject ThreadAllowlist threadAllowlist) {
        super(providerAllowlist, threadAllowlist);
    }

    @VisibleForTesting
    ConfluenceSecurityMemberAccess(ClassExtractor classExtractor) {
        this(null, null);
        this.classExtractor = classExtractor;
    }

    protected boolean isClassAllowlisted(Class<?> clazz) {
        if (!ContainerManager.isContainerSetup()) {
            return true;
        }
        if (super.isClassAllowlisted(clazz)) {
            return true;
        }
        if (this.classExtractor.extractClassLoader(clazz) instanceof BundleWiringImpl.BundleClassLoader) {
            if (this.ognlAllowListConfigurator.get().isClassAllowed(clazz)) {
                return true;
            }
            LOG.warn("Plugin class {} has not been allowlisted for use in OGNL expressions. Please add a class or package allowlisting entry within a Struts module in your plugin descriptor. Please refer to Confluence DC developer documentation for more info.", (Object)clazz.getName());
        }
        return false;
    }
}

