/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.ModuleCompleteKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@Internal
public class MultipartUploadConfigurator {
    private final Map<ModuleCompleteKey, Set<Pattern>> patternsByPluginModuleKey = new HashMap<ModuleCompleteKey, Set<Pattern>>();
    private final Set<Pattern> unauthorisedAllowedPatterns = new HashSet<Pattern>(COMPILED_UNAUTHORISED_ALLOWED_PATTERNS);
    private static final String UNAUTHORISED_ALLOWED_PATTERNS = System.getProperty("multipart.unauthorised.allowed.patterns", "");
    private static final List<Pattern> COMPILED_UNAUTHORISED_ALLOWED_PATTERNS = MultipartUploadConfigurator.buildPatternsList(UNAUTHORISED_ALLOWED_PATTERNS, ",");

    public synchronized void registerPluginPatterns(ModuleCompleteKey moduleCompleteKey, Set<Pattern> patterns) {
        Set<Pattern> existingPatterns = this.patternsByPluginModuleKey.get(moduleCompleteKey);
        if (existingPatterns != null) {
            throw new IllegalArgumentException("Plugin module key " + String.valueOf(moduleCompleteKey) + " already registered");
        }
        this.patternsByPluginModuleKey.put(moduleCompleteKey, new HashSet<Pattern>(patterns));
        this.unauthorisedAllowedPatterns.addAll(patterns);
    }

    public synchronized void clearPluginPatterns(ModuleCompleteKey moduleCompleteKey) {
        Set<Pattern> patterns = this.patternsByPluginModuleKey.get(moduleCompleteKey);
        if (patterns == null) {
            throw new IllegalArgumentException("Plugin module key " + String.valueOf(moduleCompleteKey) + " not registered");
        }
        this.unauthorisedAllowedPatterns.removeAll(patterns);
        this.patternsByPluginModuleKey.remove(moduleCompleteKey);
    }

    public Set<Pattern> getUnauthorisedAllowedPatterns() {
        return Collections.unmodifiableSet(this.unauthorisedAllowedPatterns);
    }

    public static List<Pattern> buildPatternsList(String patterns, String separator) {
        if (patterns == null || patterns.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.stream(patterns.split(separator)).map(token -> Pattern.compile(token.trim())).toList();
    }
}

