/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.impl.struts.ClassExtractor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.Plugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.felix.framework.BundleWiringImpl;

public class OgnlAllowListConfigurator {
    private final Map<ModuleCompleteKey, Set<Class<?>>> allowListPluginMapping = new HashMap();
    private final Map<ModuleCompleteKey, Map<String, Set<String>>> packageAllowListPluginMapping = new HashMap<ModuleCompleteKey, Map<String, Set<String>>>();
    private Set<Class<?>> allowlistedClasses = new HashSet();
    private Map<String, Set<String>> allowlistedPackages = new HashMap<String, Set<String>>();
    private final ClassExtractor classExtractor;

    public OgnlAllowListConfigurator() {
        this(new ClassExtractor());
    }

    @VisibleForTesting
    OgnlAllowListConfigurator(ClassExtractor classExtractor) {
        this.classExtractor = classExtractor;
    }

    public void registerClassAllowListForPlugin(Plugin plugin, ModuleCompleteKey moduleCompleteKey, Set<String> ognlAllowlistClasses) throws ClassNotFoundException {
        if (this.allowListPluginMapping.get(moduleCompleteKey) != null) {
            throw new IllegalArgumentException("Class allowlist for plugin module " + String.valueOf(moduleCompleteKey) + " already registered");
        }
        HashSet<Class> pluginAllowList = new HashSet<Class>();
        for (String clazz : ognlAllowlistClasses) {
            pluginAllowList.add(plugin.loadClass(clazz, this.getClass()));
        }
        this.allowListPluginMapping.put(moduleCompleteKey, pluginAllowList);
        this.reconstructClassAllowlist();
    }

    public void registerPackageAllowListForPlugin(ModuleCompleteKey moduleCompleteKey, String symbolicName, Set<String> ognlAllowlistPackages) {
        if (this.packageAllowListPluginMapping.get(moduleCompleteKey) != null) {
            throw new IllegalArgumentException("Package allowlist for plugin module " + String.valueOf(moduleCompleteKey) + " already registered");
        }
        Map<String, Set<String>> pluginAllowlist = Map.of(symbolicName, ognlAllowlistPackages);
        this.packageAllowListPluginMapping.put(moduleCompleteKey, pluginAllowlist);
        this.reconstructPackageAllowlist();
    }

    public void clearClassAllowListForPlugin(ModuleCompleteKey moduleCompleteKey) {
        Set<Class<?>> existingList = this.allowListPluginMapping.get(moduleCompleteKey);
        if (existingList == null) {
            throw new IllegalArgumentException("Allowlist for plugin module " + String.valueOf(moduleCompleteKey) + " not registered");
        }
        this.allowListPluginMapping.remove(moduleCompleteKey);
        this.reconstructClassAllowlist();
    }

    public void clearPackageAllowListForPlugin(ModuleCompleteKey moduleCompleteKey) {
        Map<String, Set<String>> existingList = this.packageAllowListPluginMapping.get(moduleCompleteKey);
        if (existingList == null) {
            throw new IllegalArgumentException("Allowlist for plugin " + String.valueOf(moduleCompleteKey) + " not registered");
        }
        this.packageAllowListPluginMapping.remove(moduleCompleteKey);
        this.reconstructPackageAllowlist();
    }

    public boolean isClassAllowed(Class<?> clazz) {
        return this.allowlistedClasses.contains(clazz) || this.isClassPackageAllowlisted(clazz);
    }

    private boolean isClassPackageAllowlisted(Class<?> clazz) {
        ClassLoader classLoader = this.classExtractor.extractClassLoader(clazz);
        if (!(classLoader instanceof BundleWiringImpl.BundleClassLoader)) {
            return false;
        }
        Set<String> allowListForPlugin = this.allowlistedPackages.get(this.classExtractor.extractPluginBundle(classLoader).getSymbolicName());
        return allowListForPlugin != null && this.isClassBelongsToPackages(this.classExtractor.extractPackage(clazz), allowListForPlugin);
    }

    private boolean isClassBelongsToPackages(Package pkg, Set<String> matchingPackages) {
        List<String> packageParts = Arrays.asList(pkg.getName().split("\\."));
        return IntStream.range(0, packageParts.size()).mapToObj(i -> String.join((CharSequence)".", packageParts.subList(0, i + 1))).anyMatch(matchingPackages::contains);
    }

    private void reconstructClassAllowlist() {
        this.allowlistedClasses = this.allowListPluginMapping.values().stream().reduce(new HashSet(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    private void reconstructPackageAllowlist() {
        this.allowlistedPackages = this.packageAllowListPluginMapping.values().stream().reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }
}

