/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.plugin.LegacySpringContainerAccessor;
import com.atlassian.confluence.plugin.struts.PluginAwareActionConfig;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import java.util.Map;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.factory.DefaultActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginAwareActionFactory
extends DefaultActionFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareActionFactory.class);

    public Object buildAction(String actionName, String namespace, ActionConfig config, Map<String, Object> extraContext) throws Exception {
        if (!(config instanceof PluginAwareActionConfig)) {
            return super.buildAction(actionName, namespace, config, extraContext);
        }
        PluginAwareActionConfig pluginAwareActionConfig = (PluginAwareActionConfig)config;
        try {
            return PluginAwareActionFactory.buildPluginAction(pluginAwareActionConfig, ((Object)((Object)this)).getClass());
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationException("Unable to instantiate action %s for plugin %s".formatted(config.getClassName(), pluginAwareActionConfig.getPlugin().getKey()), (Throwable)e);
        }
    }

    private static Object buildPluginAction(PluginAwareActionConfig actionConfig, Class<?> callingClass) throws ReflectiveOperationException {
        Plugin plugin = actionConfig.getPlugin();
        log.debug("Loading PluginAware action class {} via plugin [{}]", (Object)actionConfig.getClassName(), (Object)plugin.getKey());
        Class actionClass = plugin.loadClass(actionConfig.getClassName(), callingClass);
        if (plugin instanceof ContainerManagedPlugin) {
            log.debug("Creating action bean {} via container-managed plugin [{}]", (Object)actionConfig.getClassName(), (Object)plugin.getKey());
            return LegacySpringContainerAccessor.createBean((Plugin)plugin, (Class)actionClass);
        }
        log.debug("Creating action bean {} from {} [{}] via direct instantiation", new Object[]{actionConfig.getClassName(), plugin.getClass().getName(), plugin.getKey()});
        return actionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

