/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.plugin.LegacySpringContainerAccessor;
import com.atlassian.confluence.plugin.struts.PluginAwareInterceptorConfig;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.InterceptorConfig;
import org.apache.struts2.factory.DefaultInterceptorFactory;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.Interceptor;
import org.apache.struts2.interceptor.WithLazyParams;
import org.apache.struts2.util.reflection.ReflectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAwareInterceptorFactory
extends DefaultInterceptorFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareInterceptorFactory.class);
    private ReflectionProvider reflectionProvider;

    @Inject
    public void setReflectionProvider(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
        super.setReflectionProvider(reflectionProvider);
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map<String, String> interceptorRefParams) throws ConfigurationException {
        if (!(interceptorConfig instanceof PluginAwareInterceptorConfig)) {
            return super.buildInterceptor(interceptorConfig, interceptorRefParams);
        }
        PluginAwareInterceptorConfig pluginAwareInterceptorConfig = (PluginAwareInterceptorConfig)interceptorConfig;
        try {
            return this.buildPluginInterceptor(pluginAwareInterceptorConfig, interceptorRefParams, ((Object)((Object)this)).getClass());
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationException("Unable to instantiate interceptor %s for plugin %s".formatted(interceptorConfig.getClassName(), pluginAwareInterceptorConfig.getPlugin().getKey()), (Throwable)e);
        }
    }

    private Interceptor buildPluginInterceptor(PluginAwareInterceptorConfig interceptorConfig, Map<String, String> interceptorRefParams, Class<?> callingClass) throws ReflectiveOperationException {
        Interceptor interceptor;
        Plugin plugin = interceptorConfig.getPlugin();
        log.debug("Loading PluginAware interceptor class {} via plugin [{}]", (Object)interceptorConfig.getClassName(), (Object)plugin.getKey());
        Class interceptorClass = plugin.loadClass(interceptorConfig.getClassName(), callingClass);
        if (plugin instanceof ContainerManagedPlugin) {
            log.debug("Creating interceptor bean {} via container-managed plugin [{}]", (Object)interceptorConfig.getClassName(), (Object)plugin.getKey());
            interceptor = (Interceptor)LegacySpringContainerAccessor.createBean((Plugin)plugin, (Class)interceptorClass);
        } else {
            log.debug("Creating interceptor bean {} from {} [{}] via direct instantiation", new Object[]{interceptorConfig.getClassName(), plugin.getClass().getName(), plugin.getKey()});
            interceptor = (Interceptor)interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (!(interceptor instanceof WithLazyParams)) {
            HashMap<String, String> params = interceptorConfig.getParams() == null ? new HashMap<String, String>() : new HashMap(interceptorConfig.getParams());
            params.putAll(interceptorRefParams);
            this.reflectionProvider.setProperties(params, (Object)interceptor);
        }
        interceptor.init();
        return interceptor;
    }
}

