/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.plugin.LegacySpringContainerAccessor;
import com.atlassian.confluence.plugin.struts.PluginAwareResultConfig;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import java.util.Map;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.ResultConfig;
import org.apache.struts2.factory.StrutsResultFactory;
import org.apache.struts2.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAwareResultFactory
extends StrutsResultFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareResultFactory.class);

    public Result buildResult(ResultConfig resultConfig, Map<String, Object> extraContext) throws Exception {
        if (!(resultConfig instanceof PluginAwareResultConfig)) {
            return super.buildResult(resultConfig, extraContext);
        }
        PluginAwareResultConfig pluginAwareResultConfig = (PluginAwareResultConfig)resultConfig;
        try {
            return this.buildPluginResult(pluginAwareResultConfig, extraContext, ((Object)((Object)this)).getClass());
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationException("Unable to instantiate result %s for plugin %s".formatted(resultConfig.getClassName(), pluginAwareResultConfig.getPlugin().getKey()), (Throwable)e);
        }
    }

    private Result buildPluginResult(PluginAwareResultConfig resultConfig, Map<String, Object> extraContext, Class<?> callingClass) throws ReflectiveOperationException {
        Result result;
        Plugin plugin = resultConfig.getPlugin();
        log.debug("Loading PluginAware result class {} via plugin [{}]", (Object)resultConfig.getClassName(), (Object)plugin.getKey());
        Class resultClass = plugin.loadClass(resultConfig.getClassName(), callingClass);
        if (plugin instanceof ContainerManagedPlugin) {
            log.debug("Creating result bean {} via container-managed plugin [{}]", (Object)resultConfig.getClassName(), (Object)plugin.getKey());
            result = (Result)LegacySpringContainerAccessor.createBean((Plugin)plugin, (Class)resultClass);
        } else {
            log.debug("Creating result bean {} from {} [{}] via direct instantiation", new Object[]{resultConfig.getClassName(), plugin.getClass().getName(), plugin.getKey()});
            result = (Result)resultClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (resultConfig.getParams() != null) {
            this.setParameters(extraContext, result, resultConfig.getParams());
        }
        return result;
    }
}

