/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.struts;

import com.atlassian.confluence.plugin.struts.PluginAwareActionConfig;
import com.atlassian.confluence.plugin.struts.PluginAwareInterceptorConfig;
import com.atlassian.confluence.plugin.struts.PluginAwareResultConfig;
import com.atlassian.plugin.Plugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.config.entities.InterceptorConfig;
import org.apache.struts2.config.entities.PackageConfig;
import org.apache.struts2.config.entities.ResultConfig;
import org.apache.struts2.config.entities.ResultTypeConfig;
import org.apache.struts2.config.providers.XmlDocConfigurationProvider;
import org.apache.struts2.inject.ContainerBuilder;
import org.apache.struts2.util.location.LocatableProperties;
import org.apache.struts2.util.location.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginModuleXmlConfigurationProvider
extends XmlDocConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PluginModuleXmlConfigurationProvider.class);
    private final Plugin plugin;
    private final Runnable disableModuleRunnable;
    private List<ResultTypeConfig> addedResultTypes;

    public PluginModuleXmlConfigurationProvider(Document document, Plugin plugin, Runnable disableModuleRunnable) {
        super(new Document[]{document});
        this.plugin = plugin;
        this.disableModuleRunnable = disableModuleRunnable;
    }

    public void register(ContainerBuilder containerBuilder, LocatableProperties locatableProperties) throws ConfigurationException {
    }

    public void loadPackages() throws ConfigurationException {
        try {
            this.addedResultTypes = new ArrayList<ResultTypeConfig>();
            super.loadPackages();
        }
        catch (Throwable e) {
            LOG.error("Failed to load packages for Struts module of plugin {}", (Object)this.plugin.getKey(), (Object)e);
            this.disableModuleRunnable.run();
            throw e;
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(className);
        }
    }

    protected ActionConfig buildActionConfig(Element actionElement, Location location, PackageConfig.Builder packageContext, Map<String, ResultConfig> results) {
        ActionConfig actionConfig = super.buildActionConfig(actionElement, location, packageContext, results);
        return new PluginAwareActionConfig(actionConfig, this.plugin);
    }

    protected ResultTypeConfig buildResultTypeConfig(Element resultTypeElement, Location location, String paramName) {
        ResultTypeConfig resultTypeConfig = super.buildResultTypeConfig(resultTypeElement, location, paramName);
        this.addedResultTypes.add(resultTypeConfig);
        return resultTypeConfig;
    }

    protected ResultConfig buildResultConfig(String name, ResultTypeConfig config, Location location, Map<String, String> params) {
        ResultConfig resultConfig = super.buildResultConfig(name, config, location, params);
        if (this.addedResultTypes.contains(config)) {
            resultConfig = new PluginAwareResultConfig(resultConfig, this.plugin);
        }
        return resultConfig;
    }

    protected InterceptorConfig buildInterceptorConfig(Element interceptorElement) {
        InterceptorConfig interceptorConfig = super.buildInterceptorConfig(interceptorElement);
        return new PluginAwareInterceptorConfig(interceptorConfig, this.plugin);
    }
}

