/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.struts;

import com.atlassian.confluence.plugin.struts.PluginAwareActionConfig;
import com.atlassian.plugin.Plugin;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.struts2.config.RuntimeConfiguration;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.config.impl.DefaultConfiguration;

public class PluginAwareStrutsConfiguration
extends DefaultConfiguration {
    private Map<ActionKey, Plugin> pluginActionConfigs = Collections.emptyMap();

    public PluginAwareStrutsConfiguration(String defaultBeanName) {
        super(defaultBeanName);
    }

    public void rebuildRuntimeConfiguration() {
        ImmutableMap.Builder actionConfigBuilder = ImmutableMap.builder();
        this.getPackageConfigs().values().stream().filter(packageConfig -> !packageConfig.isAbstract()).forEach(packageConfig -> packageConfig.getActionConfigs().values().stream().filter(actionConfig -> actionConfig instanceof PluginAwareActionConfig).map(actionConfig -> (PluginAwareActionConfig)((Object)((Object)actionConfig))).forEach(actionConfig -> {
            if (actionConfig.getName() != null && actionConfig.getPlugin() != null) {
                actionConfigBuilder.put((Object)new ActionKey(packageConfig.getNamespace(), actionConfig.getName()), (Object)actionConfig.getPlugin());
            }
        }));
        this.pluginActionConfigs = actionConfigBuilder.build();
        super.rebuildRuntimeConfiguration();
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        final RuntimeConfiguration actual = super.getRuntimeConfiguration();
        return new RuntimeConfiguration(){

            public ActionConfig getActionConfig(String namespace, String name) {
                return this.convertToPluginAwareActionConfig(namespace, actual.getActionConfig(namespace, name));
            }

            public Map<String, Map<String, ActionConfig>> getActionConfigs() {
                return Maps.transformEntries((Map)actual.getActionConfigs(), (namespace, innerMap) -> innerMap == null ? null : Maps.transformValues((Map)innerMap, actionConfig -> this.convertToPluginAwareActionConfig((String)namespace, (ActionConfig)actionConfig)));
            }

            private ActionConfig convertToPluginAwareActionConfig(String namespace, ActionConfig actionConfig) {
                if (actionConfig == null) {
                    return null;
                }
                Plugin associatedPlugin = PluginAwareStrutsConfiguration.this.pluginActionConfigs.get(new ActionKey(namespace.equals("/") ? "" : namespace, actionConfig.getName()));
                if (associatedPlugin == null) {
                    return actionConfig;
                }
                return new PluginAwareActionConfig(actionConfig, associatedPlugin);
            }
        };
    }

    private record ActionKey(String namespace, String name) {
    }
}

