/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.xstream;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.impl.xstream.ConfluenceXStreamImpl;
import com.atlassian.confluence.impl.xstream.XStream111;
import com.atlassian.confluence.impl.xstream.security.XStreamSecurityConfigurator;
import com.atlassian.confluence.setup.xstream.AtomicReferenceConverter;
import com.atlassian.confluence.setup.xstream.ConfluenceXStream;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamInternal;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamManager;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.security.serialblocklist.xstream.BlocklistRestrictedXStream;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultConfluenceXStreamManager
implements ConfluenceXStreamManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceXStreamManager.class);
    public static final String XSTREAM_11_STORAGE_PROPERTY = "xstream.11.storage";
    public static final String XSTREAM_ALLOW_LIST_PROPERTY = "xstream.allowlist.enable";
    public static final String XSTREAM_WHITE_LIST_DEPRECATED_PROPERTY = "xstream.whitelist.enable";
    private final ResettableLazyReference<ConfluenceXStreamInternal> confluenceXStreamReference;
    private final Map<String, String> aliases;
    private final ClassLoader defaultClassLoader;
    private final XStreamSecurityConfigurator securityConfigurator;

    public DefaultConfluenceXStreamManager(Map<String, String> aliases, ClassLoader classLoader, XStreamSecurityConfigurator securityConfigurator) {
        this.aliases = Objects.requireNonNullElseGet(aliases, Collections::emptyMap);
        this.defaultClassLoader = Objects.requireNonNullElseGet(classLoader, () -> this.getClass().getClassLoader());
        this.securityConfigurator = securityConfigurator;
        this.confluenceXStreamReference = Lazy.resettable(() -> this.createAndInitializeXStream(this.defaultClassLoader));
        if (!DefaultConfluenceXStreamManager.isAllowListEnabled()) {
            log.warn("Ignoring attempt to disable allowlist via sys prop - this is no longer supported.");
        }
    }

    @Override
    public ConfluenceXStream getPluginXStream(ClassLoader classLoader) {
        return this.createAndInitializeXStream(classLoader);
    }

    @Override
    public ConfluenceXStream getConfluenceXStream() {
        return (ConfluenceXStream)this.confluenceXStreamReference.get();
    }

    @Override
    public void resetXStream() {
        this.confluenceXStreamReference.reset();
    }

    private ConfluenceXStreamInternal createAndInitializeXStream(ClassLoader classLoader) {
        PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider();
        ConfluenceXStreamInternal confluenceXStream = this.createNewConfluenceXStream((ReflectionProvider)reflectionProvider, classLoader, Boolean.getBoolean(XSTREAM_11_STORAGE_PROPERTY));
        this.securityConfigurator.configureXStreamSecurity(confluenceXStream);
        this.aliases.forEach((alias, aliasClassName) -> {
            try {
                Class aliasClass = ClassLoaderUtils.loadClass((String)aliasClassName, DefaultConfluenceXStreamManager.class);
                confluenceXStream.alias((String)alias, aliasClass);
            }
            catch (ClassNotFoundException e) {
                throw new InfrastructureException("Error loading DefaultConfluenceXStreamManager - could not find class : " + aliasClassName + " for alias " + alias, (Throwable)e);
            }
        });
        return confluenceXStream;
    }

    private ConfluenceXStreamInternal createNewConfluenceXStream(ReflectionProvider reflectProvider, ClassLoader classLoader, boolean is11StorageEnabled) {
        ClassLoaderReference classLoaderReference = new ClassLoaderReference(this.defaultClassLoader);
        XStream111 xStream111 = new XStream111(reflectProvider, classLoaderReference);
        xStream111.registerConverter(new AtomicReferenceConverter(xStream111.getMapper()), 10000);
        BlocklistRestrictedXStream xStreamBundled = new BlocklistRestrictedXStream(reflectProvider, (HierarchicalStreamDriver)new XppDriver(), classLoaderReference);
        xStreamBundled.registerConverter((Converter)new AtomicReferenceConverter(xStreamBundled.getMapper()), 10000);
        ConfluenceXStreamImpl confluenceXStream = is11StorageEnabled ? new ConfluenceXStreamImpl((XStream)xStream111, (XStream)xStreamBundled) : new ConfluenceXStreamImpl((XStream)xStreamBundled, (XStream)xStream111);
        classLoaderReference.setReference(classLoader);
        return confluenceXStream;
    }

    private static boolean isAllowListEnabled() {
        if (!Objects.isNull(System.getProperty(XSTREAM_ALLOW_LIST_PROPERTY))) {
            if (Boolean.getBoolean(XSTREAM_ALLOW_LIST_PROPERTY)) {
                log.warn("XStream's default behaviour is allowList, no need to use xstream.whitelist.enable");
            }
            return Boolean.getBoolean(XSTREAM_ALLOW_LIST_PROPERTY);
        }
        if (!Objects.isNull(System.getProperty(XSTREAM_WHITE_LIST_DEPRECATED_PROPERTY))) {
            if (Boolean.getBoolean(XSTREAM_WHITE_LIST_DEPRECATED_PROPERTY)) {
                log.warn("XStream's default behaviour is allowList, no need to use xstream.whitelist.enable");
            }
            return Boolean.getBoolean(XSTREAM_WHITE_LIST_DEPRECATED_PROPERTY);
        }
        return true;
    }
}

