/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.xstream.security;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamInternal;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class XStreamSecurityConfigurator {
    private static final Logger log = LoggerFactory.getLogger(XStreamSecurityConfigurator.class);
    private static final String ALLOW_LIST_EXTRA_PROPERTY = "xstream.allowlist.extra";
    private static final String WHITE_LIST_EXTRA_DEPRECATED_PROPERTY = "xstream.whitelist.extra";
    private static final Pattern CSV_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Set<String> ALLOWED_TYPES = ImmutableSet.of((Object)"com.atlassian.bonnie.Searchable", (Object)"com.atlassian.confluence.admin.tasks.AdminTaskData", (Object)"com.atlassian.confluence.content.Content", (Object)"com.atlassian.confluence.content.ContentProperties", (Object)"com.atlassian.confluence.content.ContentProperty", (Object)"com.atlassian.confluence.core.AbstractLabelableEntityObject", (Object[])new String[]{"com.atlassian.confluence.core.AbstractVersionedEntityObject", "com.atlassian.confluence.core.Addressable", "com.atlassian.confluence.core.AnnotatedEntityObject", "com.atlassian.confluence.core.ConfluenceEntityObject", "com.atlassian.confluence.core.ContentEntityObject", "com.atlassian.confluence.core.ContentTypeAware", "com.atlassian.confluence.core.CustomPageSettings", "com.atlassian.confluence.core.Versioned", "com.atlassian.confluence.dmz.relations.RelatableEntity", "com.atlassian.confluence.extra.testbandanaplugin.TestClass", "com.atlassian.confluence.extra.webdav.ConfluenceDavSession", "com.atlassian.confluence.extra.webdav.ResourceStates", "com.atlassian.confluence.extra.webdav.ResourceStates$SpaceAttributePlaceHolder", "com.atlassian.confluence.extra.webdav.ResourceStates$ContentAttributePlaceHolder", "com.atlassian.confluence.extra.webdav.WebdavSettings", "com.atlassian.confluence.index.status.ReIndexError", "com.atlassian.confluence.index.status.ReIndexJob", "com.atlassian.confluence.index.status.ReIndexJob$Progress", "com.atlassian.confluence.index.status.ReIndexNodeStatus", "com.atlassian.confluence.index.status.ReIndexNodeStatus$State", "com.atlassian.confluence.index.status.ReIndexStage", "com.atlassian.confluence.jmx.JmxSMTPMailServer", "com.atlassian.confluence.labels.EditableLabelable", "com.atlassian.confluence.labels.Labelable", "com.atlassian.confluence.macro.browser.beans.MacroParameter", "com.atlassian.confluence.macro.browser.beans.MacroParameterType", "com.atlassian.confluence.mail.ConfluenceImapMailServer", "com.atlassian.confluence.mail.ConfluencePopMailServer", "com.atlassian.confluence.mail.ConfluenceSmtpMailServer", "com.atlassian.confluence.mail.archive.MailAccount", "com.atlassian.confluence.mail.archive.PopMailAccount", "com.atlassian.confluence.mail.Authorization", "com.atlassian.confluence.mail.Authorization$OAuth2", "com.atlassian.confluence.plugins.emailgateway.api.EmailBodyType", "com.atlassian.confluence.plugins.emailgateway.api.EmailHeaders", "com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail", "com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThread", "com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadKey", "com.atlassian.confluence.renderer.ShortcutLinkConfig", "com.atlassian.confluence.renderer.UserMacroConfig", "com.atlassian.confluence.rest.v2.api.model.RestObject$Properties", "com.atlassian.confluence.schedule.ScheduledJobConfiguration", "com.atlassian.confluence.schedule.ScheduledJobHistory", "com.atlassian.confluence.setup.settings.CustomHtmlSettings", "com.atlassian.confluence.setup.settings.Settings", "com.atlassian.confluence.setup.settings.SpaceSettings", "com.atlassian.confluence.setup.settings.beans.CaptchaSettings", "com.atlassian.confluence.setup.settings.beans.ColourSchemesSettings", "com.atlassian.confluence.setup.settings.beans.LoginManagerSettings", "com.atlassian.confluence.setup.settings.beans.ReferrerSettings", "com.atlassian.confluence.themes.AbstractColourScheme", "com.atlassian.confluence.themes.BaseColourScheme", "com.atlassian.confluence.themes.ColourScheme", "com.atlassian.confluence.user.ConfluenceUser", "com.atlassian.confluence.user.ConfluenceUserImpl", "com.atlassian.confluence.user.UserVerificationToken", "com.atlassian.confluence.user.UserVerificationTokenType", "com.atlassian.confluence.util.http.ConfluenceHttpParameters", "com.atlassian.confluence.util.message.DefaultMessage", "com.atlassian.confluence.util.message.Message", "com.atlassian.core.bean.EntityObject", "com.atlassian.core.util.Clock", "com.atlassian.core.util.PairType", "com.atlassian.mail.server.AbstractMailServer", "com.atlassian.mail.server.MailServer", "com.atlassian.mail.server.impl.SMTPMailServerImpl", "com.atlassian.plugin.StoredPluginState", "com.atlassian.plugin.manager.PluginPersistentState", "com.atlassian.user.Entity", "com.atlassian.user.User", "java.io.ObjectStreamField", "java.io.Serializable", "java.lang.Boolean", "java.lang.Byte", "java.lang.CharSequence", "java.lang.Character", "java.lang.Class", "java.lang.Cloneable", "java.lang.Comparable", "java.lang.Enum", "java.lang.Float", "java.lang.Integer", "java.lang.Iterable", "java.lang.Long", "java.lang.Number", "java.lang.Object", "java.lang.String", "java.lang.String$CaseInsensitiveComparator", "java.lang.constant.Constable", "java.lang.constant.ConstantDesc", "java.net.InetAddress", "java.net.InetAddress$InetAddressHolder", "java.net.URI", "java.net.URL", "java.net.URL$DefaultFactory", "java.net.URLStreamHandler", "java.net.URLStreamHandlerFactory", "java.net.spi.InetAddressResolver", "java.security.Principal", "java.security.ProtectionDomain", "java.time.Instant", "java.util.AbstractCollection", "java.util.AbstractList", "java.util.AbstractMap", "java.util.AbstractSet", "java.util.ArrayList", "java.util.Collection", "java.util.Collections$EmptyList", "java.util.CollSer", "java.util.Comparator", "java.util.Date", "java.util.GregorianCalendar", "java.util.HashMap", "java.util.HashMap$Node", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", "java.util.List", "java.util.Map", "java.util.Map$Entry", "java.util.NavigableMap", "java.util.NavigableSet", "java.util.Properties", "java.util.RandomAccess", "java.util.SequencedCollection", "java.util.SequencedMap", "java.util.SequencedSet", "java.util.Set", "java.util.SortedMap", "java.util.SortedSet", "java.util.TreeSet", "java.util.concurrent.ConcurrentMap", "java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.locks.ReentrantLock", "java.util.regex.Pattern", "jakarta.mail.Address", "jakarta.mail.internet.InternetAddress", "jdk.internal.misc.Unsafe", "jdk.internal.reflect.ReflectionFactory", "jdk.internal.reflect.ReflectionFactory$Config", "org.apache.commons.lang3.mutable.Mutable", "org.apache.commons.lang3.mutable.MutableBoolean", "org.apache.jackrabbit.webdav.DavSession", "org.apache.jackrabbit.webdav.lock.LockManager", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.spi.ExtendedLogger", "org.apache.logging.slf4j.Log4jLogger", "org.apache.logging.slf4j.Log4jMarkerFactory", "org.joda.time.Chronology", "org.joda.time.DateTime", "org.joda.time.ReadableDateTime", "org.joda.time.ReadableInstant", "org.joda.time.base.AbstractDateTime", "org.joda.time.base.AbstractInstant", "org.joda.time.base.BaseDateTime", "org.slf4j.IMarkerFactory", "org.slf4j.Logger", "org.slf4j.spi.LocationAwareLogger", "sun.net.www.protocol.file.Handler", "sun.net.www.protocol.jrt.Handler", "sun.util.calendar.BaseCalendar", "sun.util.calendar.Gregorian", "sun.util.calendar.JulianCalendar"});
    private final Map<String, Set<String>> types = new HashMap<String, Set<String>>();
    private final Set<String> userConfiguredAllowedPackages = this.getUserConfiguredAllowedPackages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureXStreamSecurity(ConfluenceXStreamInternal confluenceXStream) {
        confluenceXStream.setUpDefaultSecurity();
        confluenceXStream.allowTypes(ALLOWED_TYPES.toArray(new String[0]));
        confluenceXStream.allowTypes(this.userConfiguredAllowedPackages.toArray(new String[0]));
        XStreamSecurityConfigurator xStreamSecurityConfigurator = this;
        synchronized (xStreamSecurityConfigurator) {
            confluenceXStream.allowTypes(this.mergeSets(this.types).toArray(new String[0]));
        }
    }

    public synchronized void addAllowTypes(String pluginKey, Set<String> types) {
        this.types.computeIfAbsent(pluginKey, k -> new HashSet()).addAll(types);
    }

    public synchronized void clearPluginSecurityData(String pluginKey) {
        this.types.remove(pluginKey);
    }

    private @NonNull Set<String> getUserConfiguredAllowedPackages() {
        String allowListExtra = System.getProperty(ALLOW_LIST_EXTRA_PROPERTY, this.getWhiteListExtra());
        return Optional.ofNullable(allowListExtra).map(s -> CSV_PATTERN.splitAsStream(allowListExtra).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet))).orElse(Collections.emptySet());
    }

    private @NonNull Set<String> mergeSets(Map<String, Set<String>> stringSets) {
        HashSet<String> strings = new HashSet<String>();
        stringSets.values().forEach(strings::addAll);
        return strings;
    }

    @Deprecated
    private String getWhiteListExtra() {
        String extraWhiteList = System.getProperty(WHITE_LIST_EXTRA_DEPRECATED_PROPERTY);
        if (extraWhiteList != null) {
            log.warn("xstream.whitelist.extra usage is deprecated. Please use 'xstream.allowlist.extra' instead.");
        }
        return extraWhiteList;
    }
}

