/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.attachments.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.extra.attachments.SpaceAttachments;
import com.atlassian.confluence.extra.attachments.SpaceAttachmentsUtils;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SpaceAttachmentsAction
extends ConfluenceActionSupport
implements SpaceAware {
    private SpaceAttachmentsUtils spaceAttachmentsUtils;
    private String sortBy;
    private String fileExtension;
    private String labelFilter;
    private String messageKey;
    private String[] messageParameter;
    private int pageNumber;
    private int totalAttachments;
    private int totalPage;
    private int pageSize;
    private List<Attachment> latestVersionsOfAttachments;
    private boolean allowFilterByFileExtension;
    private boolean showFilter;
    private boolean showAttachmentsNotFound;
    private Space space;
    private final PaginationSupport<Attachment> paginationSupport = new PaginationSupport(20);

    public void validate() {
        super.validate();
        if (!LabelUtil.isValidLabelNames((String)this.getLabelFilter())) {
            this.setShowAttachmentsNotFound(false);
            this.addFieldError("attachmentLabelsString", this.getText(this.getText("attachments.labels.invalid.characters", new String[]{LabelParser.getInvalidCharactersAsString()})));
        }
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws InvalidSearchException {
        HashSet<String> labels = new HashSet<String>(SpaceAttachmentsAction.getLabelsForFilter(this.getLabelFilter(), this.labelManager));
        SpaceAttachments spaceAttachments = null;
        if (!labels.isEmpty() || StringUtils.isBlank((CharSequence)this.getLabelFilter())) {
            spaceAttachments = this.spaceAttachmentsUtils.getAttachmentList(this.getSpace().getKey(), this.getPageNumber(), this.getTotalAttachments(), this.getPageSize(), this.getSortBy(), this.formatFileExtension(this.getFileExtension()), labels);
            this.setLatestVersionsOfAttachments(spaceAttachments.getAttachmentList());
            this.setTotalAttachments(spaceAttachments.getTotalAttachments());
            this.setTotalPage(spaceAttachments.getTotalPage());
        }
        this.setShowAttachmentsNotFound(true);
        if (spaceAttachments == null || spaceAttachments.getAttachmentList().isEmpty()) {
            this.setMessages();
        }
        return "success";
    }

    public void setSpaceAttachmentsUtils(SpaceAttachmentsUtils spaceAttachmentsUtils) {
        this.spaceAttachmentsUtils = spaceAttachmentsUtils;
    }

    public String getSpaceKey() {
        return this.getSpace().getKey();
    }

    @StrutsParameter
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    @StrutsParameter
    public void setTotalAttachments(int totalAttachments) {
        this.totalAttachments = totalAttachments;
    }

    public int getTotalAttachments() {
        return this.totalAttachments;
    }

    public void setLatestVersionsOfAttachments(List<Attachment> latestVersionsOfAttachments) {
        this.latestVersionsOfAttachments = latestVersionsOfAttachments;
    }

    public List<Attachment> getLatestVersionsOfAttachments() {
        return this.latestVersionsOfAttachments;
    }

    @StrutsParameter
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    @StrutsParameter
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    @StrutsParameter
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @StrutsParameter
    public void setAllowFilterByFileExtension(boolean allowFilterByFileExtension) {
        this.allowFilterByFileExtension = allowFilterByFileExtension;
    }

    public boolean isAllowFilterByFileExtension() {
        return this.allowFilterByFileExtension;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }

    @StrutsParameter
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @StrutsParameter
    public void setShowFilter(boolean showFilter) {
        this.showFilter = showFilter;
    }

    public boolean isShowFilter() {
        return this.showFilter;
    }

    private String formatFileExtension(String fileExtension) {
        if (StringUtils.isNotBlank((CharSequence)fileExtension) && fileExtension.startsWith(".")) {
            fileExtension = fileExtension.substring(fileExtension.lastIndexOf(".") + 1);
        }
        return fileExtension;
    }

    public PaginationSupport<Attachment> getPaginationSupport() {
        return this.paginationSupport;
    }

    public String getLabelFilter() {
        return this.labelFilter;
    }

    @StrutsParameter
    public void setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
    }

    public boolean isShowAttachmentsNotFound() {
        return this.showAttachmentsNotFound;
    }

    @StrutsParameter
    public void setShowAttachmentsNotFound(boolean showAttachmentsNotFound) {
        this.showAttachmentsNotFound = showAttachmentsNotFound;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String[] getMessageParameter() {
        return this.messageParameter;
    }

    private void setMessages() {
        if (StringUtils.isNotBlank((CharSequence)this.getFileExtension()) && StringUtils.isNotBlank((CharSequence)this.getLabelFilter())) {
            this.messageKey = "attachments.no.attachments.with.label.and.ending.with.ext";
            this.messageParameter = new String[]{HtmlUtil.htmlEncode((String)this.getFileExtension()), HtmlUtil.htmlEncode((String)this.getLabelFilter())};
        } else if (StringUtils.isNotBlank((CharSequence)this.getFileExtension())) {
            this.messageKey = "attachments.no.attachments.ending.with.ext";
            this.messageParameter = new String[]{HtmlUtil.htmlEncode((String)this.getFileExtension())};
        } else if (StringUtils.isNotBlank((CharSequence)this.getLabelFilter())) {
            this.messageKey = "attachments.no.attachments.with.label";
            this.messageParameter = new String[]{HtmlUtil.htmlEncode((String)this.getLabelFilter())};
        } else {
            this.messageKey = "attachments.no.attachments.to.space";
            this.messageParameter = new String[]{HtmlUtil.htmlEncode((String)this.space.getKey())};
        }
    }

    public static List<String> getLabelsForFilter(String labels, LabelManager labelManager) {
        ArrayList<String> labelsList = new ArrayList<String>();
        if (labels != null) {
            for (String labelString : LabelUtil.split((String)labels)) {
                if (StringUtils.isBlank((CharSequence)labelString)) continue;
                ParsedLabelName labelName = LabelParser.parse((String)labelString, (User)AuthenticatedUserThreadLocal.get());
                Label label = labelManager.getLabel(labelName);
                if (label != null) {
                    labelsList.add(label.getName());
                    continue;
                }
                return Collections.emptyList();
            }
        }
        return labelsList;
    }
}

