/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.attachments.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.extra.attachments.ImagePreviewRenderer;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@Path(value="details")
public class DetailsResource {
    private final AttachmentManager attachmentManager;
    private final ImagePreviewRenderer imagePreviewRenderer;
    private final PermissionManager permissionManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;

    @Inject
    public DetailsResource(@ComponentImport AttachmentManager attachmentManager, ImagePreviewRenderer imagePreviewRenderer, @ComponentImport PermissionManager permissionManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport LocaleManager localeManager) {
        this.attachmentManager = attachmentManager;
        this.imagePreviewRenderer = imagePreviewRenderer;
        this.permissionManager = permissionManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    @Produces(value={"text/html"})
    @GET
    @Path(value="preview")
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ"})
    public String getPreview(@QueryParam(value="attachmentId") long attachmentId) {
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment != null) {
            if (!this.hasViewPermission(attachment)) {
                throw new PermissionException(this.getI18NBean().getText("confluence.extra.attachments.error.noviewpermission"));
            }
            try {
                return this.getAttachmentPreviewHtml(attachment);
            }
            catch (XhtmlException e) {
                throw new ServiceException();
            }
        }
        return "";
    }

    private String getAttachmentPreviewHtml(Attachment attachment) throws XhtmlException {
        return this.imagePreviewRenderer.render(attachment, (ConversionContext)new DefaultConversionContext((RenderContext)new PageContext(attachment.getContainer())));
    }

    private boolean hasViewPermission(Attachment attachment) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment);
    }

    private I18NBean getI18NBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }
}

