/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.applinks;

import com.atlassian.applinks.host.OsgiServiceProxyFactory;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.confluence.applinks.ConfluenceInternalHostApplication;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.impl.applinks.ConfluenceUserAccessResolver;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.integration.jira.applinks.UserAccessResolver;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import jakarta.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplinksHostConfig {
    @Resource
    private PluginAccessor pluginAccessor;
    @Resource
    private GlobalSettingsManager settingsManager;
    @Resource
    private ConfluenceSidManager sidManager;
    @Resource
    private SpaceManager spaceManager;
    @Resource
    private PermissionManager permissionManager;
    @Resource
    private WebResourceUrlProvider webResourceUrlProvider;
    @Resource
    private OsgiContainerManager osgiContainerManager;

    @Bean
    @AvailableToPlugins(interfaces={HostApplication.class, InternalHostApplication.class})
    ConfluenceInternalHostApplication applinkHostApplication() {
        return new ConfluenceInternalHostApplication(this.pluginAccessor, this.settingsManager, this.sidManager, this.typeAccessor(), this.spaceManager, this.permissionManager, this.webResourceUrlProvider);
    }

    TypeAccessor typeAccessor() {
        return (TypeAccessor)new OsgiServiceProxyFactory(this.osgiContainerManager).createProxy(TypeAccessor.class, 10000L);
    }

    @Bean
    @AvailableToPlugins(interfaces={UserAccessResolver.class})
    ConfluenceUserAccessResolver userAccessResolver() {
        return new ConfluenceUserAccessResolver(this.permissionManager);
    }
}

