/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;

public class JsonPropertyPermissionDelegate
implements PermissionDelegate<Object> {
    private final PermissionManager permissionManager;

    public JsonPropertyPermissionDelegate(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean canView(ConfluenceUser user, Object target) {
        return this.hasPermission(user, target, Permission.VIEW);
    }

    public boolean canView(ConfluenceUser user) {
        return false;
    }

    public boolean canEdit(ConfluenceUser user, Object target) {
        return this.hasPermission(user, target, Permission.EDIT);
    }

    public boolean canSetPermissions(ConfluenceUser user, Object target) {
        return false;
    }

    public boolean canRemove(ConfluenceUser user, Object target) {
        return this.canEdit(user, target);
    }

    public boolean canExport(ConfluenceUser user, Object target) {
        throw new UnsupportedOperationException();
    }

    public boolean canAdminister(ConfluenceUser user, Object target) {
        return this.hasPermission(user, target, Permission.ADMINISTER);
    }

    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.permissionManager.hasPermissionNoExemptions(user, Permission.EDIT, container);
    }

    public boolean canCreateInTarget(ConfluenceUser user, Class typeToCreate) {
        return false;
    }

    private boolean hasPermission(ConfluenceUser user, Object target, Permission permission) {
        CustomContentEntityObject entityObject = (CustomContentEntityObject)target;
        ContentEntityObject container = entityObject.getContainer();
        if (container != null) {
            return this.permissionManager.hasPermissionNoExemptions(user, permission, (Object)container);
        }
        return this.permissionManager.hasPermissionNoExemptions(user, permission, (Object)entityObject.getSpace());
    }
}

