/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.plugins.contentproperty.index.schema.SchemaFieldType;
import com.atlassian.confluence.plugins.index.api.mapping.DateFieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.DoubleFieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMappingsProvider;
import com.atlassian.confluence.plugins.index.api.mapping.StringFieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.TextFieldMapping;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ContentPropertyIndexSchema
implements FieldMappingsProvider {
    private final Multimap<String, ContentPropertySchemaField> schema;

    public ContentPropertyIndexSchema(Multimap<String, ContentPropertySchemaField> schema) {
        this.schema = ImmutableMultimap.copyOf(schema);
    }

    public Collection<ContentPropertySchemaField> getSchemaFieldsByKey(String key) {
        return this.schema.get((Object)key);
    }

    public Set<String> getContentPropertyKeys() {
        return this.schema.keySet();
    }

    public Multimap<String, ContentPropertySchemaField> asMultimap() {
        return this.schema;
    }

    public Collection<FieldMapping> getFieldMappings() {
        return this.schema.entries().stream().map(entry -> this.createFieldMapping((ContentPropertySchemaField)entry.getValue())).collect(Collectors.toList());
    }

    private FieldMapping createFieldMapping(ContentPropertySchemaField field) {
        return switch (field.getFieldType()) {
            default -> throw new MatchException(null, null);
            case SchemaFieldType.STRING -> StringFieldMapping.builder((String)field.getFieldName()).build();
            case SchemaFieldType.TEXT -> TextFieldMapping.builder((String)field.getFieldName()).build();
            case SchemaFieldType.NUMBER -> DoubleFieldMapping.builder((String)field.getFieldName()).build();
            case SchemaFieldType.DATE -> DateFieldMapping.builder((String)field.getFieldName()).build();
        };
    }
}

