/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.mapping.DateFieldMapping;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DateFieldTransformation
implements Function<JsonField, Option<FieldDescriptor>> {
    private static final Logger log = LoggerFactory.getLogger(DateFieldTransformation.class);
    private static final DateTimeFormatter ISO8601_DATETIME_PARSER = ISODateTimeFormat.dateTimeParser();

    DateFieldTransformation() {
    }

    public Option<FieldDescriptor> apply(@NonNull JsonField input) {
        JsonNode jsonNode = input.getNodeValue();
        if (jsonNode.isLong() && jsonNode.longValue() > 0L) {
            return this.createFromLong(input.getFieldName(), jsonNode.longValue());
        }
        if (jsonNode.isTextual()) {
            return this.createFromString(input.getFieldName(), jsonNode.textValue());
        }
        log.debug("Couldn't transform JSON node to a date field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }

    private Option<FieldDescriptor> createFromDate(String fieldName, Date value) {
        return Option.some((Object)new DateFieldMapping.Builder(fieldName).build().createField(value));
    }

    private Option<FieldDescriptor> createFromLong(String fieldName, long value) {
        return this.createFromDate(fieldName, new DateTime(value).toDate());
    }

    private Option<FieldDescriptor> createFromString(String fieldName, String value) {
        try {
            return this.createFromDate(fieldName, ISO8601_DATETIME_PARSER.parseDateTime(value).toDate());
        }
        catch (IllegalArgumentException e) {
            log.debug("Exception during date parsing occurred, {} did not match any registered datetime formats", (Object)value);
            return Option.none();
        }
    }
}

