/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.mapping.DoubleFieldMapping;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NumberFieldTransformation
implements Function<JsonField, Option<FieldDescriptor>> {
    private static final Logger log = LoggerFactory.getLogger(NumberFieldTransformation.class);

    NumberFieldTransformation() {
    }

    public Option<FieldDescriptor> apply(@NonNull JsonField input) {
        if (input.getNodeValue().isNumber()) {
            return Option.some((Object)new DoubleFieldMapping.Builder(input.getFieldName()).store(FieldDescriptor.Store.NO.isStored()).build().createField(input.getNodeValue().doubleValue()));
        }
        log.debug("Couldn't transform JSON node to a number field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }
}

