/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.fields;

import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.plugins.contentproperty.search.query.ContentPropertySearchQueryFactory;
import com.atlassian.confluence.plugins.cql.spi.fields.AbstractDateRangeFieldHandler;
import com.atlassian.confluence.search.SearchPlatform;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.UISupport;

public class DateTimeContentPropertyAliasFieldHandler
extends AbstractDateRangeFieldHandler {
    private final ContentPropertySchemaField schemaField;
    private final SearchPlatformConfig searchPlatformConfig;
    private final ContentPropertySearchQueryFactory contentPropertySearchQueryFactory;
    public static final String KEY = "content-property-field-sort-mapper";

    protected DateTimeContentPropertyAliasFieldHandler(String aliasName, ContentPropertySchemaField schemaField, SearchPlatformConfig searchPlatformConfig) {
        super(aliasName, FieldMetaData.builder().isAlias(true).uiSupport((UISupport)schemaField.getUiSupport().getOrNull()).build());
        this.schemaField = schemaField;
        this.searchPlatformConfig = searchPlatformConfig;
        this.contentPropertySearchQueryFactory = new ContentPropertySearchQueryFactory();
    }

    protected DateRangeQuery.Builder newDateRangeBuilder() {
        return DateRangeQuery.newDateRangeQuery((String)this.schemaField.getFieldName());
    }

    protected SearchSort getSearchSort(SearchSort.Order order) {
        SearchSort.Type searchSortType = this.searchPlatformConfig.searchPlatform() == SearchPlatform.LUCENE ? SearchSort.Type.LONG : SearchSort.Type.STRING;
        return this.contentPropertySearchQueryFactory.buildContentPropertySearchSort(this.schemaField, searchSortType, order);
    }
}

