/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class JiraCspFragment
implements CspFragment {
    private static final Set<String> URL_PATTERNS = Set.of("/**");
    private static final Set<CspDirective> CSP_DIRECTIVES = Set.of(CspDirective.IMG_SRC);
    private final ApplicationLinkService applicationLinkService;
    private Set<URI> origins;

    public JiraCspFragment(ApplicationLinkService applicationLinkService, EventListenerRegistrar eventListenerRegistrar) {
        this.applicationLinkService = applicationLinkService;
        eventListenerRegistrar.register((Object)this);
        this.refreshOrigins();
    }

    public Set<CspDirective> getCSPDirectives() {
        return CSP_DIRECTIVES;
    }

    public Set<URI> getCSPOrigins(CspDirective cspDirective) {
        return this.origins;
    }

    public Set<String> getUrlPatterns() {
        return URL_PATTERNS;
    }

    @EventListener
    public void onApplicationLinkAddedEvent(ApplicationLinkAddedEvent event) {
        this.refreshOrigins();
    }

    @EventListener
    public void onApplicationLinkDeletedEvent(ApplicationLinkDeletedEvent event) {
        this.refreshOrigins();
    }

    @EventListener
    public void onApplicationLinkDetailsChangedEvent(ApplicationLinkDetailsChangedEvent event) {
        this.refreshOrigins();
    }

    private void refreshOrigins() {
        this.origins = StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).map(applicationLink -> URI.create(String.valueOf(applicationLink.getDisplayUrl()) + "/")).collect(Collectors.toUnmodifiableSet());
    }
}

