/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.internal.integration.jira.IconRequest;
import com.atlassian.internal.integration.jira.InternalJiraService;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.text.StringEscapeUtils;

@UnrestrictedAccess
public class JiraIconServlet
extends HttpServlet {
    private static final long serialVersionUID = -1290766128724561166L;
    private static final String JIRA_PROJECT_ID_PATTERN = "\\d+";
    protected InternalJiraService jiraService;

    public JiraIconServlet(InternalJiraService internalJiraService) {
        this.jiraService = internalJiraService;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String projectId = req.getParameter("pid");
        if (projectId == null || !projectId.matches(JIRA_PROJECT_ID_PATTERN)) {
            resp.setStatus(400);
            resp.setContentType("text/html; charset=utf-8");
            PrintWriter writer = resp.getWriter();
            writer.println("Invalid project ID: " + StringEscapeUtils.escapeHtml4((String)projectId));
            writer.flush();
            return;
        }
        IconRequest context = new IconRequest(req);
        this.jiraService.streamIcon(context, resp);
    }
}

