/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.basicauth.spring;

import com.atlassian.audit.api.AuditService;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.BasicAuthService;
import com.atlassian.plugins.authentication.basicauth.audit.AdvancedBasicAuthAuditLogHandler;
import com.atlassian.plugins.authentication.basicauth.audit.BasicAuthAuditEventListener;
import com.atlassian.plugins.authentication.basicauth.audit.BasicAuthAuditLogHandler;
import com.atlassian.plugins.authentication.basicauth.filter.DisableBasicAuthResponseWriter;
import com.atlassian.plugins.authentication.basicauth.job.UpdateBasicAuthConfigJob;
import com.atlassian.plugins.authentication.basicauth.service.BasicAuthDao;
import com.atlassian.plugins.authentication.basicauth.service.CachingBasicAuthService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.SchedulerService;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class})
public class BlockingBasicAuthConfiguration {
    @Bean
    public BasicAuthAuditEventListener basicAuthAuditEventListener(EventPublisher eventPublisher, BasicAuthAuditLogHandler basicAuthAuditLogHandler) {
        return new BasicAuthAuditEventListener(basicAuthAuditLogHandler, eventPublisher);
    }

    @Bean
    public BasicAuthAuditLogHandler basicAuthAuditLogHandler(AuditService auditService) {
        return new AdvancedBasicAuthAuditLogHandler(auditService);
    }

    @Bean
    public DisableBasicAuthResponseWriter disableBasicAuthResponseWriter(I18nResolver i18nResolver) {
        return new DisableBasicAuthResponseWriter(i18nResolver);
    }

    @Bean
    public BasicAuthDao basicAuthDao(PluginSettingsFactory pluginSettings, EventPublisher eventPublisher, ClusterLockService clusterLockService, I18nResolver i18nResolver) {
        return new BasicAuthDao(pluginSettings, eventPublisher, clusterLockService, i18nResolver);
    }

    @Bean
    public CachingBasicAuthService cachingBasicAuthService(BasicAuthDao basicAuthDao) {
        return new CachingBasicAuthService(basicAuthDao);
    }

    @Bean
    public UpdateBasicAuthConfigJob updateBasicAuthConfigJob(BasicAuthDao basicAuthDao, CachingBasicAuthService cachingBasicAuthService, SchedulerService schedulerService) {
        return new UpdateBasicAuthConfigJob(basicAuthDao, cachingBasicAuthService, schedulerService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportUpdateBasicAuthConfigJob(UpdateBasicAuthConfigJob updateBasicAuthConfigJob) {
        return OsgiServices.exportOsgiService((Object)updateBasicAuthConfigJob, (ExportOptions)ExportOptions.as(LifecycleAware.class, (Class[])new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportBasicAuthService(CachingBasicAuthService cachingBasicAuthService) {
        return OsgiServices.exportOsgiService((Object)cachingBasicAuthService, (ExportOptions)ExportOptions.as(BasicAuthService.class, (Class[])new Class[0]));
    }
}

