/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.captcha.impl;

import com.atlassian.bitbucket.user.CaptchaResponse;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.model.CaptchaDataEntity;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCaptchaService
implements CaptchaService {
    private static final String CAPTCHA_URL = "/captcha?__r=";
    private static final Logger log = LoggerFactory.getLogger(BitbucketCaptchaService.class);
    private final ApplicationProperties applicationProperties;
    private final com.atlassian.bitbucket.user.CaptchaService captchaService;

    public BitbucketCaptchaService(ApplicationProperties applicationProperties, com.atlassian.bitbucket.user.CaptchaService captchaService) {
        this.applicationProperties = applicationProperties;
        this.captchaService = captchaService;
    }

    @Override
    @Nonnull
    public CaptchaDataEntity getCaptchaData(@Nonnull HttpServletRequest request) {
        return new CaptchaDataEntity(request.getSession().getId(), this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + CAPTCHA_URL + Math.random());
    }

    @Override
    public boolean isCaptchaRequired(@Nonnull String username) {
        try {
            return this.captchaService.isRequired(username);
        }
        catch (NoSuchUserException e) {
            log.debug("Skipping captcha required check for non-existent user: {}", (Object)username);
            return false;
        }
    }

    @Override
    public boolean isValid(@Nonnull String captchaId, @Nonnull String captchaChallenge) {
        if (Strings.isNullOrEmpty((String)captchaId) || Strings.isNullOrEmpty((String)captchaChallenge)) {
            return false;
        }
        return this.captchaService.validate(new CaptchaResponse(captchaId, captchaChallenge));
    }
}

