/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.captcha.impl;

import com.atlassian.jira.bc.security.login.CaptchaValidator;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.model.CaptchaDataEntity;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;

public class JiraCaptchaService
implements CaptchaService {
    private static final String CAPTCHA_URL = "/captcha?__r=";
    private final LoginService loginService;
    private final ApplicationProperties applicationProperties;
    private final CaptchaValidator captchaValidator;

    public JiraCaptchaService(LoginService loginService, ApplicationProperties applicationProperties, CaptchaValidator captchaValidator) {
        this.loginService = loginService;
        this.applicationProperties = applicationProperties;
        this.captchaValidator = captchaValidator;
    }

    @Override
    @Nonnull
    public CaptchaDataEntity getCaptchaData(@Nonnull HttpServletRequest request) {
        return new CaptchaDataEntity(request.getSession().getId(), this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + CAPTCHA_URL + Math.random());
    }

    @Override
    public boolean isCaptchaRequired(@Nonnull String userName) {
        return Optional.ofNullable(this.loginService.getLoginInfo(userName)).map(LoginInfo::isElevatedSecurityCheckRequired).orElse(false);
    }

    @Override
    public boolean isValid(@Nonnull String captchaId, @Nonnull String captchaChallenge) {
        return this.captchaValidator.validate(captchaId, captchaChallenge);
    }
}

