/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.captcha.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public record CaptchaDataEntity(@JsonProperty(value="captchaId") String captchaId, @JsonProperty(value="captchaImageUrl") String captchaImageUrl) {
    @Override
    public String toString() {
        return "CaptchaDataEntity{captchaId='" + this.captchaId + "', captchaImageUrl='" + this.captchaImageUrl + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CaptchaDataEntity data) {
        return new Builder(data);
    }

    public static final class Builder {
        private String captchaImageUrl;
        private String captchaId;

        private Builder() {
        }

        private Builder(CaptchaDataEntity entity) {
            this.captchaImageUrl = entity.captchaImageUrl();
            this.captchaId = entity.captchaId();
        }

        public Builder setCaptchaImageUrl(String captchaImageUrl) {
            this.captchaImageUrl = captchaImageUrl;
            return this;
        }

        public Builder setCaptchaId(String captchaId) {
            this.captchaId = captchaId;
            return this;
        }

        public CaptchaDataEntity build() {
            return new CaptchaDataEntity(this.captchaId, this.captchaImageUrl);
        }
    }
}

