/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.common.analytics.AbstractStatisticsCollectionService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.events.JitProvisionedUsersCountEvent;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.UserProvisionedEvent;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerNodeStatisticsCollectionService
extends AbstractStatisticsCollectionService {
    private static final Logger log = LoggerFactory.getLogger(PerNodeStatisticsCollectionService.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)PerNodeStatisticsCollectionService.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"analytics-collection-local");
    private final AtomicLong jitUserProvisionedCount = new AtomicLong(0L);
    private final NodeIdProvider nodeIdProvider;

    public PerNodeStatisticsCollectionService(EventPublisher eventPublisher, SchedulerService schedulerService, NodeIdProvider nodeIdProvider) {
        super(eventPublisher, schedulerService);
        this.nodeIdProvider = nodeIdProvider;
    }

    @Override
    @PostConstruct
    public void register() throws SchedulerServiceException {
        super.register();
        this.eventPublisher.register((Object)this);
    }

    @Override
    @PreDestroy
    public void unregister() {
        super.unregister();
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    @Nonnull
    protected RunMode getRunMode() {
        return RunMode.RUN_LOCALLY;
    }

    @Override
    protected JobId getJobId() {
        return JOB_ID;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JOB_RUNNER_KEY;
    }

    @EventListener
    public void onUserProvisionedEvent(UserProvisionedEvent event) {
        this.jitUserProvisionedCount.incrementAndGet();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        log.debug("Collecting Local Authentication statistics");
        this.eventPublisher.publish((Object)new JitProvisionedUsersCountEvent(this.nodeIdProvider.getNodeId(), this.jitUserProvisionedCount.getAndSet(0L)));
        return JobRunnerResponse.success();
    }
}

