/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.tsv.internal.events.TsvWebsudoVerificationEvent;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.event.NativeWebsudoVerificationEvent;
import com.atlassian.plugins.authentication.common.analytics.events.WebsudoVerificationAnalyticsEvent;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;

public class WebsudoAnalyticsEventPublisher {
    private final EventPublisher eventPublisher;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;

    @Inject
    public WebsudoAnalyticsEventPublisher(EventPublisher eventPublisher, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        this.eventPublisher = eventPublisher;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onNativeWebsudoVerificationEvent(NativeWebsudoVerificationEvent e) {
        if (this.shouldPublishEvent()) {
            this.eventPublisher.publish((Object)new WebsudoVerificationAnalyticsEvent(e.userKey(), VerificationMethod.PASSWORD));
        }
    }

    @EventListener
    public void onTsvWebsudoVerificationEvent(TsvWebsudoVerificationEvent e) {
        if (this.shouldPublishEvent()) {
            this.eventPublisher.publish((Object)new WebsudoVerificationAnalyticsEvent(e.userKey(), e.verificationMethod()));
        }
    }

    private boolean shouldPublishEvent() {
        return !this.authenticationPluginFeatureService.isTsvWebsudoDisabled() && !this.authenticationPluginFeatureService.isLegacyModeEnabled();
    }
}

