/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.properties;

import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;

public class SystemPropertyBasedAuthenticationPluginFeatureService
implements AuthenticationPluginFeatureInternalService {
    public static final String LEGACY_MODE_SYSTEM_PROPERTY = "atlassian.authentication.legacy.mode";
    public static final String TWO_STEP_VERIFICATION_ENFORCEMENT_SYSTEM_PROPERTY = "atlassian.authentication.2sv.enforcement.enabled";
    public static final String TWO_STEP_VERIFICATION_ALL_USERS_ENFORCEMENT_SYSTEM_PROPERTY = "atlassian.authentication.2sv.enforcement.all.users.enabled";
    public static final String TWO_STEP_VERIFICATION_WEB_SUDO_SYSTEM_PROPERTY = "atlassian.authentication.2sv.websudo.disabled";
    public static final String TWO_STEP_VERIFICATION_RATE_LIMITING_SYSTEM_PROPERTY = "atlassian.authentication.2sv.rate.limit.disabled";
    public static final String SAML_AUTH_REQUESTS_SIGNING_SYSTEM_PROPERTY = "atlassian.authentication.sso.saml.auth.requests.signing.enabled";

    public boolean isLegacyModeEnabled() {
        String legacyModeSystemPropertyValue = System.getProperty(LEGACY_MODE_SYSTEM_PROPERTY);
        if (legacyModeSystemPropertyValue == null) {
            return true;
        }
        return !legacyModeSystemPropertyValue.equals("false");
    }

    public boolean isTsvWebsudoDisabled() {
        String webSudoSystemPropertyValue = System.getProperty(TWO_STEP_VERIFICATION_WEB_SUDO_SYSTEM_PROPERTY);
        if (webSudoSystemPropertyValue == null) {
            return false;
        }
        return webSudoSystemPropertyValue.equals("true");
    }

    @Override
    public boolean isEnforcementEnabledForAdmins() {
        if (System.getProperty(TWO_STEP_VERIFICATION_ENFORCEMENT_SYSTEM_PROPERTY) == null) {
            return false;
        }
        return Boolean.getBoolean(TWO_STEP_VERIFICATION_ENFORCEMENT_SYSTEM_PROPERTY);
    }

    @Override
    public boolean isEnforcementEnabledForAllUsers() {
        if (System.getProperty(TWO_STEP_VERIFICATION_ALL_USERS_ENFORCEMENT_SYSTEM_PROPERTY) == null) {
            return false;
        }
        return Boolean.getBoolean(TWO_STEP_VERIFICATION_ALL_USERS_ENFORCEMENT_SYSTEM_PROPERTY);
    }

    @Override
    public boolean isRateLimitingDisabled() {
        if (System.getProperty(TWO_STEP_VERIFICATION_RATE_LIMITING_SYSTEM_PROPERTY) == null) {
            return false;
        }
        return Boolean.getBoolean(TWO_STEP_VERIFICATION_RATE_LIMITING_SYSTEM_PROPERTY);
    }

    @Override
    public boolean isSamlAuthRequestsSigningEnabled() {
        String rawSamlAuthRequestsSigningValue = this.getRawSamlAuthRequestsSigningValue();
        if (rawSamlAuthRequestsSigningValue == null) {
            return false;
        }
        return rawSamlAuthRequestsSigningValue.equals("true");
    }

    public String getRawLegacyModeValue() {
        return System.getProperty(LEGACY_MODE_SYSTEM_PROPERTY);
    }

    public String getRawSamlAuthRequestsSigningValue() {
        return System.getProperty(SAML_AUTH_REQUESTS_SIGNING_SYSTEM_PROPERTY);
    }
}

